% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqpac_S4classes.R
\docType{class}
\name{reanno-class}
\alias{reanno-class}
\alias{reanno}
\title{S4 object for reanno output}
\usage{
reanno(Overview, Full_anno)
}
\arguments{
\item{Overview}{A tibble data.frame with summarized results from mapping
using the \code{\link{map_reanno}} function that has been imported into R
using the \code{\link{make_reanno}} function. Rows represents sequences
from the original PAC-object.}

\item{Full_anno}{A multi-level list with tibble data.frames that contains all
that was imported by \code{\link{make_reanno}}}
}
\value{
Contains two slots:  1. Overview: A table holding a summary of the
mapping. 2. Full_anno: Lists of tables holding the full imports per mismatch
cycle (mis0, mis1 etc) and reference (mi0-ref1, mis0-ref2, mis1-ref1,
mis1-ref2 etc).
}
\description{
Holds the imported information from mapping using the map_reanno function.
All information are held in tibble class (tbl/tbl_df) tables from the tibble
package.
}
\examples{

##### Create an reanno object

##  First load a PAC- object

load(system.file("extdata", "drosophila_sRNA_pac_filt_anno.Rdata", 
                   package = "seqpac", mustWork = TRUE))
 
##  Then specify paths to fasta references
# If you are having problem see the vignette small RNA guide for more info.
 
 trna_file <- system.file("extdata/trna", "tRNA.fa", 
                          package = "seqpac", mustWork = TRUE)
 trna_dir <- dirname(trna_file)
 
 if(!sum(stringr::str_count(list.files(trna_dir), ".ebwt")) ==6){     
     Rbowtie::bowtie_build(trna_file, 
                           outdir=trna_dir, 
                           prefix="tRNA", force=TRUE)
                           }
 
 ref_paths <- list(trna= trna_file)
                                    
##  Add output path of your choice.
# Here we use the R temporary folder depending on platform
 output <- paste0(tempdir(),"/seqpac/test")

## Make sure it is empty (otherwise you will be prompted for a question)
out_fls  <- list.files(output, recursive=TRUE)
closeAllConnections()
suppressWarnings(file.remove(paste(output, out_fls, sep="/")))

##  Then map your PAC-object against the fasta references
 map_reanno(pac, input=ref_paths, output=output,
               type="internal", mismatches=0,  import="biotype", 
               threads=2, keep_temp=FALSE, override=TRUE)

##  Then import and generate a reanno-object of the temporary bowtie-files
reanno <- make_reanno(output, PAC=pac, mis_fasta_check = TRUE)
                                    
## Now make some search terms against reference names to create shorter names
# Theses can be used to create factors in downstream analysis
# One search hit (regular expressions) gives one new short name 
bio_search <- list(trna =c("_tRNA", "mt:tRNA"))
 
 
## You can merge directly with your PAC-object by adding your original 
# PAC-object, that you used with map_reanno, to merge_pac option.
 pac <- add_reanno(reanno, bio_search=bio_search, 
                       type="biotype", bio_perfect=FALSE, 
                       mismatches = 0, merge_pac=pac)
                       
                       
## Turn your S3 list to an S4 reanno-object
isS4(reanno)
names(reanno)
table(overview(reanno)$trna)
 
reanno_s3 <- as(reanno, "list")
isS4(reanno_s3)   

# Turns S3 reanno object into a S4 
reanno_s4 <- as.reanno(reanno_s3)
isS4(reanno_s4) 
 
}
