## ----DEA_one_pack, echo=TRUE, results="hide", message=FALSE, warning=FALSE----
library(ExpHunterSuite)
data(toc)
data(target)
degh_out_one_pack <- main_degenes_Hunter(raw=toc, 
                                         target=target,
                                         modules="D") # D for DESeq2

## ----input_data, echo=TRUE, results="as.is", message=FALSE, warning=FALSE-----
head(toc)
head(target)

## ----input_files, echo=TRUE, results="as.is"----------------------------------
system.file("extData", "table_of_counts.txt", package = "ExpHunterSuite")
system.file("extData", "target.txt", package = "ExpHunterSuite")

## ----DEA_multi_pack, echo=TRUE, results="hide", message=FALSE, warning=FALSE----
degh_out_multi_pack <- main_degenes_Hunter(raw=toc, 
                                    target=target, 
                                    modules="DEL") # D:DESeq2 E:EdgeR, L:limma

## ----standard_DEA_results, echo=TRUE------------------------------------------
head(degh_out_multi_pack$DE_all_genes)

## ----standard_DEA_model_target, echo=TRUE, results="as.is"--------------------
target_multi <- data.frame(target,
  age_group = c("adult", "child", "adult", "child", "adult", "adult", "child"))
target_multi

## ----standard_DEA_model_execute, results="hide", message=FALSE, warning=FALSE----
degh_out_model <- main_degenes_Hunter(raw=toc, target=target_multi, 
                                      modules="D", model_variables="age_group")

## ----standard_CEA, results="hide", message=FALSE, warning=FALSE---------------
degh_out_coexp <- main_degenes_Hunter(raw=toc, target=target_multi, 
                                      modules="DW", string_factors="age_group")

## ----standard_FA, results="as.is",  eval=FALSE--------------------------------
# 
# fh_out_one_pack <- main_functional_hunter( #Perform enrichment analysis
#         degh_out_one_pack,
#         model_organism = 'Mouse', # Use specified organism database
#         enrich_dbs = c("MF", "BP", "CC", "Kegg", "Reactome"), # Enrichment analysis for GO, KEGG and Reactome
#         enrich_methods = "o" # Use overepresentation analysis only
# )
# 

## ----coexp_FA, results="as.is", eval=FALSE------------------------------------
# 
# fh_out_coexp <- main_functional_hunter( # Perform enrichment analisys
#         degh_out_coexp,
#         model_organism = 'Mouse', # Use specified organism database
#         enrich_dbs = c("MF", "BP", "CC", "Kegg", "Reactome"), # Enrichment analysis for GO, KEGG and Reactome
#         enrich_methods = "o" # Use overepresentation analysi only
# )
# 

## ----c2e, echo=TRUE,  eval=FALSE, results="hide"------------------------------
# input_file <- system.file("extData", "cluster_genes.txt", package = "ExpHunterSuite")
# print(readLines(input_file,n=2))
# 
# organisms_table <- get_organism_table()
# current_organism_info <- organisms_table[rownames(organisms_table) %in% "Mouse",]
# org_db <- get_org_db(current_organism_info)
# 
# enr_lists <- main_clusters_to_enrichment(input_file, org_db=org_db,
#     current_organism_info=current_organism_info, gene_keytype="ENSEMBL")

## ----write_reports, echo=TRUE, eval=FALSE, results="hide"---------------------
# 
# write_expression_report(exp_results=degh_out_coexp)
# write_enrich_files(func_results=fh_out_one_pack)
# write_functional_report(hunter_results=degh_out_coexp,
#                         func_results=fh_out_coexp)

