% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_degenes_Hunter.R
\name{main_degenes_Hunter}
\alias{main_degenes_Hunter}
\title{Main DEgenes Hunter Function}
\usage{
main_degenes_Hunter(
  raw = NULL,
  pseudocounts = FALSE,
  target = NULL,
  count_var_quantile = 0,
  external_DEA_data = NULL,
  output_files = getwd(),
  reads = 2,
  minlibraries = 2,
  filter_type = "separate",
  p_val_cutoff = 0.05,
  lfc = 1,
  modules = "DELNW",
  minpack_common = 4,
  model_variables = "",
  numerics_as_factors = TRUE,
  string_factors = NULL,
  numeric_factors = NULL,
  WGCNA_memory = 5000,
  WGCNA_norm_method = "DESeq2",
  WGCNA_deepsplit = 2,
  WGCNA_min_genes_cluster = 20,
  WGCNA_detectcutHeight = 0.995,
  WGCNA_mergecutHeight = 0.25,
  WGCNA_all = FALSE,
  WGCNA_blockwiseNetworkType = "signed",
  WGCNA_blockwiseTOMType = "signed",
  WGCNA_minCoreKME = 0.5,
  WGCNA_minCoreKMESize = NULL,
  WGCNA_minKMEtoStay = 0.2,
  WGCNA_corType = "pearson",
  multifactorial = "",
  library_sizes = NULL
)
}
\arguments{
\item{raw}{Dataframe with raw counts per sample and feature}

\item{pseudocounts}{boolean, activate if the input contains pseudocounts}

\item{target}{set with control and treatment information}

\item{count_var_quantile}{quantile variance threshold}

\item{external_DEA_data}{external DEA set}

\item{output_files}{otput files path}

\item{reads}{set of reads}

\item{minlibraries}{minimum of libraries to use a set of data}

\item{filter_type}{filter type to ba applied. Allowed: "separate" or "global"}

\item{p_val_cutoff}{p-value threshold}

\item{lfc}{minimum logFold Change}

\item{modules}{modules to be executed. Allowed: DESeq2 (D), NOISeq (N),
Limma (L), EdgeR (E), WGCNA (W)}

\item{minpack_common}{minimum of pack that must be significant to tag
a gene as significant}

\item{model_variables}{custom model}

\item{numerics_as_factors}{transform numeric values to factors. Default: TRUE}

\item{string_factors}{string factors for WGCNA}

\item{numeric_factors}{numeric factors for WGCNA}

\item{WGCNA_memory}{see WGCNA package}

\item{WGCNA_norm_method}{see WGCNA package}

\item{WGCNA_deepsplit}{see WGCNA package}

\item{WGCNA_min_genes_cluster}{see WGCNA package}

\item{WGCNA_detectcutHeight}{see WGCNA package}

\item{WGCNA_mergecutHeight}{see WGCNA package}

\item{WGCNA_all}{see WGCNA package}

\item{WGCNA_blockwiseNetworkType}{see WGCNA package}

\item{WGCNA_blockwiseTOMType}{see WGCNA package}

\item{WGCNA_minCoreKME}{see WGCNA package}

\item{WGCNA_minCoreKMESize}{see WGCNA package}

\item{WGCNA_minKMEtoStay}{see WGCNA package}

\item{WGCNA_corType}{see WGCNA package}

\item{multifactorial}{specify interaction/effect when multifactorial design}

\item{library_sizes}{NULL or a dataframe with sample names and library sizes}
}
\value{
expression analysis result object with studies performed
}
\description{
This function allows you to perform the DEG analysis with different
algorithms.
}
\examples{
data(toc)
data(target)
degh_out <- main_degenes_Hunter(raw=toc, target=target, modules="D")
}
\keyword{method}
