% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesameData_getProbes.R
\name{sesameData_getProbesByRegion}
\alias{sesameData_getProbesByRegion}
\title{Get probes by genomic region}
\usage{
sesameData_getProbesByRegion(
  regs,
  chrm = NULL,
  beg = 1,
  end = -1,
  platform = NULL,
  chrm_to_exclude = NULL,
  genome = NULL
)
}
\arguments{
\item{regs}{GRanges}

\item{chrm}{chromosome, when given regs are ignored}

\item{beg}{begin, 1 if omitted}

\item{end}{end, chromosome end if omitted}

\item{platform}{EPICv2, EPIC, HM450, ...}

\item{chrm_to_exclude}{chromosome to exclude.}

\item{genome}{hg38, mm10, ... will infer if not given.
For additional mapping, download the GRanges object from
http://zwdzwd.github.io/InfiniumAnnotation
and provide the following argument
..., genome = sesameAnno_buildManifestGRanges("downloaded_file"),...
to this function.}
}
\value{
GRanges of selected probes
}
\description{
The function takes a genomic coordinate and output the a vector of probes
on the specified platform that falls in the given genomic region.
}
\examples{

## download needed data
sesameDataCache(c("Mammal40.address", "genomeInfo.hg38"))

## get probes in a region
library(GenomicRanges)
probes = sesameData_getProbesByRegion(
    GRanges('chr5', IRanges(135313937, 135419936)), platform = 'Mammal40')

## get all probes on chromosome 5
probes = sesameData_getProbesByRegion(chrm = "chr5", platform = "Mammal40")

## get all probes on chromosome X
probes = sesameData_getProbesByRegion(chrm = 'chrX', platform = "Mammal40")

## get all probes on both chromosome X and Y
probes = sesameData_getProbesByRegion(
    chrm = c('chrX', 'chrY'), platform = "Mammal40")

## get all autosomal probes
probes = sesameData_getProbesByRegion(
    chrm_to_exclude = c("chrX", "chrY"), platform = "Mammal40")

}
