% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesameData_getProbes.R
\name{sesameData_getProbesByGene}
\alias{sesameData_getProbesByGene}
\title{Get Probes by Genes or Gene Promoters}
\usage{
sesameData_getProbesByGene(
  gene_name = NULL,
  platform = NULL,
  promoter = FALSE,
  upstream = 1500,
  downstream = 1500,
  genome = NULL
)
}
\arguments{
\item{gene_name}{gene name, if NULL return all genes}

\item{platform}{EPIC or HM450}

\item{promoter}{if TRUE, use TSS instead of the whole gene}

\item{upstream}{number of bases to expand upstream of target gene}

\item{downstream}{number of bases to expand downstream of target gene}

\item{genome}{hg38 or hg19}
}
\value{
GRanges containing probes that fall into the given gene
}
\description{
Get probes mapped to a gene. All transcripts for the gene are considered.
The function takes a gene name as appears in UCSC RefGene database. The
platform and reference genome build can be changed with `platform` and
`genome` options. The function returns a vector of probes that falls
into the given gene.
}
\examples{

## download needed data
sesameDataCache(c("Mammal40.address", "genomeInfo.hg38"))

## get all probes overlapping with DNMT3A
probes <- sesameData_getProbesByGene(
    'DNMT3A', "Mammal40", upstream=500, downstream=500)

## get the promoter-associated probes
probes <- sesameData_getProbesByGene('DNMT3A', "Mammal40", promoter = TRUE)

}
