% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZhongPrefrontalData.R
\name{ZhongPrefrontalData}
\alias{ZhongPrefrontalData}
\title{Obtain the Zhong prefrontal cortex data}
\usage{
ZhongPrefrontalData(ensembl = FALSE, location = TRUE, legacy = FALSE)
}
\arguments{
\item{ensembl}{Logical scalar indicating whether the output row names should contain Ensembl identifiers.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object with a single matrix of UMI counts.
}
\description{
Obtain the human prefrontal cortex single-cell RNA-seq dataset from Zhong et al. (2018).
}
\details{
Column metadata is scraped from GEO and includes week of gestation, gender and likely cell type.

If \code{ensembl=TRUE}, the gene symbols are converted to Ensembl IDs in the row names of the output object.
Rows with missing Ensembl IDs are discarded, and only the first occurrence of duplicated IDs is retained.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link[SummarizedExperiment]{rowRanges}} of the output.
This is only performed when \code{ensembl=TRUE}.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/zhong-prefrontal}.
}
\examples{
sce <- ZhongPrefrontalData()

}
\references{
Zhong S et al. (2018). 
A single-cell RNA-seq survey of the developmental landscape of the human prefrontal cortex. 
\emph{Nature} 555, 524-528.
}
\author{
Aaron Lun
}
