\name{lpsTimecourse_mulvey2021}
\alias{lpsTimecourse_mulvey2021}
\alias{lpsTimecourse_rep1_mulvey2021}
\alias{lpsTimecourse_rep2_mulvey2021}
\alias{lpsTimecourse_rep3_mulvey2021}
\alias{psms_lpsTimecourse_rep1_mulvey2021}
\alias{psms_lpsTimecourse_rep2_mulvey2021}
\alias{psms_lpsTimecourse_rep3_mulvey2021}

\docType{data}

\title{

  Protein and PMS-level datasets from temporal abundance profiling
  experiments of THP-1 human leukaema cells stimulated with LPS
}

\description{
  These are timecourse proteomics datasets output from temporal 
  abundance experiments on THP-1 human leukaema cells stimulated 
  with LPS at 0, 2, 4, 6, 12 and 24 hours.
}

\usage{
data(lpsTimecourse_mulvey2021)
data(lpsTimecourse_rep1_mulvey2021)
data(lpsTimecourse_rep2_mulvey2021)
data(lpsTimecourse_rep3_mulvey2021)
data(psms_lpsTimecourse_rep1_mulvey2021)
data(psms_lpsTimecourse_rep2_mulvey2021)
data(psms_lpsTimecourse_rep3_mulvey2021)
}

\format{
  These data are instances of class \code{MSnSet} from package
  \code{MSnbase}.
}

\details{

  These are triplicate timecourse proteomics datasets output from temporal 
  abundance experiments on THP-1 human leukaema cells stimulated 
  with LPS. THP-1 total cell lysates were harvested at specific 
  time-points of LPS stimulation; 0, 2, 4, 6, 12 and 24 hours. 
  These were then digested, labelled with TMT 6plex, and analysed 
  by LC-MS/MS on the Q-Exactive MS (Thermo). The resulting 
  datasets were processed by Proteome 
  Discoverer software (v2.1, Thermo) and imported and analysed in 
  R using the packages \code{MSnbase} and \code{pRoloc}.
  
  PSM-level and protein-level csv files are available in the 
  code{extdata} directory and have been imported as 
  \code{MSnSet} instances using \code{readMSnSet2}. 
  There are 3 replicates and the PSM-level and protein-level
  datasets are denoted accordingly. 
  
  The dataset \code{lpsTimecourse_mulvey2021} contains the
  triplicates concatenated thus including only proteins common
  across all experiments, and is that which was used in the
  core analayis in the manuscipt by Mulvey et al 2021. The
  \code{featureData} columns contain the output (adjusted)
  p-values output from the temporal abundance
  analysis that was performed using \code{limma} and as 
  described in Mulvey et al 2021.

}

\source{
  The data was generated by C. Mulvey at the
  Cambridge Centre for Proteomics.
  \url{http://www.bio.cam.ac.uk/proteomics/}.
}

\examples{
data(lpsTimecourse_mulvey2021)
lpsTimecourse_mulvey2021
pData(lpsTimecourse_mulvey2021)
head(exprs(lpsTimecourse_mulvey2021))
}

\keyword{datasets}
