meta <- data.frame(Title=c('CCLE.log2.read.count.matrix',
                           'CCLE.overlaps',
                           'CCLE.sample.meta',
                           'CTRPv2.sensprof',
                           'EncoderDF',
                           'cmpd_sets_ChemCluster',
                           'cmpd_sets_chembl_targets',
                           'cmpd_sets_mesh',
                           'fda_drugs',
                           'lincs_sig_info',
                           'lincs_signatures',
                           'merged_gene_info',
                           'octad.LINCS.counts',
                           'phenoDF',
                           'random_gsea_score',
                           'tsne',
                           'octad.counts.and.tpm.h5',
                           'res_example.rda',
                           'sRGES_example.rda'
),
Description=c(
'log2-transformed matrix containing expression of 56,318 genes in 1,019 cell lines provided in CCLE database',
'log2-transformed matrix containing expression of 56,318 genes in 51 cell lines present in both LINCS and CCLE databases',
'data.frame containing cell lines name and tissue of origin from CCLE database',
'Cancer Therapeutics Response Portal (CTRP) data.frame containing AUC and IC50 for every drug-cell line pair',
'a data.frame (64 features by 19127 samples) computed from autoEncoder for every sample in the OCTAD database',
'list of compounds and their clusters based on chemical structures',
'list of compounds and their targets presented in ChEMBL database',
'list of compounds and their associations with 662 pharmacological MeSH Terms provided in PubChem',
'data.frame of FDA approved drugs containing name, target and clinical phase',
'data.frame for LINCS signatures including experiment id, cell line used in the experiment, purturbagen name, purturbagen type, dose and time',
'Differential expression of 978 genes in 416,560 experiments',
'data.frame with the annotation of 75,078 genes which could be used for identifier mapping',
'expression matrix of 965 genes and 19127 samples in OCTAD database (965 genes were profiled in LINCS)',
'data.frame with samples from the OCTAD database including tissue of origin, sample type (tumor-derived or healthy-derived), cancer, orginal source (e.g. TCGA), mutation and stage data if available',
'precomputed permutated gsea scores for chembl, mesh and ChemCluster databases that are used for drug enrichment analysis',
'2 dimension tSNE for every sample in the OCTAD database along with sample.id, cancer type and source of the initial data',
'expression (TPM and raw counts) matrix of 60,498 genes and 19,127 samples',
'example of differential expression analysis of HCC vs adjacent liver for OCTAD performed on genes contained in LINCs database',
'example of RGES computed from DE analysis of HCC vs adjacent liver for OCTAD performed on genes contained in LINCs database'
),
BiocVersion='3.15',
Genome='hg19',
SourceType='RDA',
SourceUrl=c(
  'https://chenlab-data-public.s3.amazonaws.com/octad/octad.db/CCLE.log2.read.count.matrix.rda',
  'https://chenlab-data-public.s3.amazonaws.com/octad/octad.db/CCLE.overlaps.rda',
  'https://chenlab-data-public.s3.amazonaws.com/octad/octad.db/CCLE.sample.meta.rda',
  'https://chenlab-data-public.s3.amazonaws.com/octad/octad.db/CTRPv2.sensprof.rda',
  'https://chenlab-data-public.s3.amazonaws.com/octad/octad.db/EncoderDF.rda',
  'https://chenlab-data-public.s3.amazonaws.com/octad/octad.db/cmpd_sets_ChemCluster.rda',
  'https://chenlab-data-public.s3.amazonaws.com/octad/octad.db/cmpd_sets_chembl_targets.rda',
  'https://chenlab-data-public.s3.amazonaws.com/octad/octad.db/cmpd_sets_mesh.rda',
  'https://chenlab-data-public.s3.amazonaws.com/octad/octad.db/fda_drugs.rda',
  'https://chenlab-data-public.s3.amazonaws.com/octad/octad.db/lincs_sig_info.rda',
  'https://chenlab-data-public.s3.amazonaws.com/octad/octad.db/lincs_signatures.rda',
  'https://chenlab-data-public.s3.amazonaws.com/octad/octad.db/merged_gene_info.rda',
  'https://chenlab-data-public.s3.amazonaws.com/octad/octad.db/octad.LINCS.counts.rda',
  'https://chenlab-data-public.s3.amazonaws.com/octad/octad.db/phenoDF.rda',
  'https://chenlab-data-public.s3.amazonaws.com/octad/octad.db/random_gsea_score.rda',
  'https://chenlab-data-public.s3.amazonaws.com/octad/octad.db/tsne.rda',
  'https://chenlab-data-public.s3-us-west-2.amazonaws.com/octad/octad.counts.and.tpm.h5',
  'https://chenlab-data-public.s3.amazonaws.com/octad/octad.db/res_example.rda',
  'https://chenlab-data-public.s3.amazonaws.com/octad/octad.db/sRGES_example.rda'
),
SourceVersion=Sys.time(),
Species="Homo sapiens",
TaxonomyId='9606',
Coordinate_1_based=TRUE,
DataProvider='Michigan State University',
Maintainer='Eugene Chekalin <chekali1@msu.edu>',
RDataClass=c(
  'matrix array',
  'matrix array',
  'data.frame',
  'data.table data.frame',
  'matrix array',
  'list',
  'list',
  'list',
  'data.frame',
  'data.table data.frame',
  'matrix array',
  'data.table data.frame',
  'matrix array',
  'data.frame',
  'list',
  'data.frame',
  'data.frame',
  'data.frame',
  'data.frame'
),
DispatchClass=c(rep('Rda',16),'H5File',rep('Rda',2)),
RDataPath=c('octad.db/CCLE.log2.read.count.matrix.rda',
  'octad.db/CCLE.overlaps.rda',
  'octad.db/CCLE.sample.meta.rda',
  'octad.db/CTRPv2.sensprof.rda',
  'octad.db/EncoderDF.rda',
  'octad.db/cmpd_sets_ChemCluster.rda',
  'octad.db/cmpd_sets_chembl_targets.rda',
  'octad.db/cmpd_sets_mesh.rda',
  'octad.db/fda_drugs.rda',
  'octad.db/lincs_sig_info.rda',
  'octad.db/lincs_signatures.rda',
  'octad.db/merged_gene_info.rda',
  'octad.db/octad.LINCS.counts.rda',
  'octad.db/phenoDF.rda',
  'octad.db/random_gsea_score.rda',
  'octad.db/tsne.rda',
  'octad.counts.and.tpm.h5',
  'octad.db/res_example.rda',
  'octad.db/sRGES_example.rda'
),
Location_Prefix='https://chenlab-data-public.s3.amazonaws.com/octad/'
)
write.csv(meta, file="inst/extdata/metadata.csv", row.names=FALSE)