% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/muleaData.R
\name{muleaData}
\alias{muleaData}
\title{muleaData - GMT Datasets for the mulea Package}
\format{
An 'ExperimentHub' object data frame with 879 records
containing gene sets (ontologies) from 27 species,
collected from 16 data sources.
Each record contains a \code{data.frame} created from a gene set
stored in Gene Matrix Transposed (GMT) format,
read by the \code{mulea::read_gmt()} command.

These \code{data.frame} GMT objects contains 3 columns:
\itemize{
\item 'ontology_id': Ontology identifier that uniquely identifies the element
within the referenced ontology.
\item 'ontology_name': Ontology name or description that provides a
user-friendly label or textual description for the 'ontology_id'.
\item 'list_of_values': Associated genes or proteins that is a vector of
identifiers of genes or proteins belonging to the 'ontology_id'.
}
}
\source{
The data were downloaded from these sources and
formatted to GMT files:
\itemize{
\item http://atrm.gao-lab.org/
\item http://flyatlas.org/atlas.cgi
\item http://geneontology.org/
\item http://signalink.org/
\item http://www.yeastract.com
\item https://github.com/saezlab/dorothea
\item https://mirtarbase.cuhk.edu.cn/~miRTarBase/miRTarBase_2022/php/index.php
\item https://reactome.org/
\item https://regulondb.ccg.unam.mx/
\item https://tflink.net/
\item https://wiki.flybase.org/wiki/FlyBase:ModENCODE_data_at_FlyBase
\item https://www.ebi.ac.uk/interpro/
\item https://www.ensembl.org
\item https://www.grnpedia.org/trrust/
\item https://www.pathwaycommons.org/
\item https://www.wikipathways.org
}
}
\usage{
query(ExperimentHub::ExperimentHub(), "muleaData")
}
\description{
muleaData provides pre-processed gene set (ontology) data for
use with the \code{mulea} R package, a comprehensive tool
for overrepresentation and functional enrichment analysis.
\code{mulea} leverages ontologies (gene and protein sets) stored
in the standardized Gene Matrix Transposed (GMT) format.
We provide these GMT files for 27 different model organisms, ranging from
\emph{Escherichia coli} to human.
These files are compiled from publicly available sources and include various
gene and protein identifiers like 'UniProt' protein IDs,
'Entrez', 'Gene Symbol', and 'Ensembl' gene IDs.
The GMT files and the scripts we applied to create them are available at
the 'ELTEbioinformatics/GMT_files_for_mulea' github repository.
For the \code{muleaData} we read these GMT files with the
\code{mulea::read_gmt()} function and saved them to
\emph{.rds} files with the standard R \code{saveRDS()} function.
}
\details{
The muleaData object is generated dynamically by querying the
\code{ExperimentHub} package.
}
\examples{
# Calling the ExperimentHub library.
library(ExperimentHub)

# Downloading the metadata from ExperimentHub.
eh <- ExperimentHub()

# Creating the muleaData variable.
muleaData <- query(ExperimentHub::ExperimentHub(), "muleaData")

# Checking the muleaData variable.
muleaData

# Calling dplyr library to explore the data
library(dplyr)

# Looking for the ExperimentalHub ID of i.e. target genes of transcription
# factors from TFLink in Caenorhabditis elegans.
mcols(muleaData) \%>\% 
  as.data.frame() \%>\% 
  dplyr::filter(species == "Caenorhabditis elegans" & 
                  sourceurl == "https://tflink.net/")

# Creating a variable for the GMT data.frame of EH8735.
# EH8735 contains small-scale measurement results, where the target genes are
# coded with Ensembl ID-s
Transcription_factor_TFLink_Caenorhabditis_elegans_SS_EnsemblID <- 
  muleaData[["EH8735"]]
  

}
\seealso{
\code{\link{ExperimentHub}}, \code{\link{query}}
}
