% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildAll.R
\name{readInSEZip}
\alias{readInSEZip}
\title{readInSEZip read a SummarizedExperiment in from a zip file}
\usage{
readInSEZip(zip_name = "SE_out.zip")
}
\arguments{
\item{zip_name}{The path to a zip file containing a SummarizedExperiment}
}
\value{
A SummarizedExperiment object.
}
\description{
This function reads in a SummarizedExperiment from a Zip file generated by writeOutSEZip.
It is designed for getting an intact SummarizedExperiment out of ExperimentHub for a data package,
so it extracts the intermediate csvs into a temporary folder to get the data into the datastructure.
}
\examples{
# We can read in a small SummarizedExperiment containing a
# subset of the built data stored directly in the package like so
small_data <- readInSEZip(
  system.file("ASmallSummarizedExperiment.zip", package="homosapienDEE2CellScore"))
}
