## easierData

Experiment Data package for `easier´ R package, which consists of:

- Internal data required for the functional performance of easier package (generated by our original work).
- Exemplary bladder cancer dataset with both processed RNA-seq data and information on response to ICB 
  therapy publicly available via IMvigor210CoreBiologies package. This data was generated by Mariathasan, S.,
  Turley, S., Nickles, D. et al. TGFβ attenuates tumour response to PD-L1 blockade by contributing to exclusion
  of T cells. Nature 554, 544–548 (2018). https://doi.org/10.1038/nature25501.
  
## Installation

You can install `easierData` package from bioconductor with:

``` r
if (!requireNamespace("BiocManager", quietly = TRUE))
    install.packages("BiocManager")

BiocManager::install("easierData")
          
```

Additionally, you can install the development version from the GitHub repository:

``` r
library("remotes")
remotes::install_github("olapuentesantana/easierData", 
                        dependencies = TRUE, build_vignettes = TRUE)
```

## Citation

If you use this data package in your work, please cite the original EaSIeR study:

Lapuente-Santana, Ó., van Genderen, M., Hilbers, P., Finotello, F., & Eduati, F. (2021). 'Interpretable systems biomarkers predict response to immune-checkpoint inhibitors.' Patterns (New York, N.Y.), 2(8), 100293. https://doi.org/10.1016/j.patter.2021.100293
