% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BlueprintEncodeData.R
\name{BlueprintEncodeData}
\alias{BlueprintEncodeData}
\title{Obtain human bulk RNA-seq data from Blueprint and ENCODE}
\usage{
BlueprintEncodeData(
  rm.NA = c("rows", "cols", "both", "none"),
  ensembl = FALSE,
  cell.ont = c("all", "nonna", "none"),
  legacy = FALSE
)
}
\arguments{
\item{rm.NA}{String specifying how missing values should be handled.
\code{"rows"} will remove genes with at least one missing value, 
\code{"cols"} will remove samples with at least one missing value,
\code{"both"} will remove any gene or sample with at least one missing value,
and \code{"none"} will not perform any removal.}

\item{ensembl}{Logical scalar indicating whether to convert row names to Ensembl IDs.
Genes without a mapping to a non-duplicated Ensembl ID are discarded.}

\item{cell.ont}{String specifying whether Cell Ontology terms should be included in the \code{\link{colData}}.
If \code{"nonna"}, all samples without a valid term are discarded;
if \code{"all"}, all samples are returned with (possibly \code{NA}) terms;
if \code{"none"}, terms are not added.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \linkS4class{SummarizedExperiment} object with a \code{"logcounts"} assay
containing the log-normalized expression values, along with cell type labels in the 
\code{\link{colData}}.
}
\description{
Download and cache the normalized expression values of 259 RNA-seq samples of
pure stroma and immune cells as generated and supplied by Blueprint and ENCODE.
}
\details{
This function provides normalized expression values for 259 bulk RNA-seq samples
generated by Blueprint and ENCODE from pure populations of stroma and immune 
cells (Martens and Stunnenberg, 2013; The ENCODE Consortium, 2012).
The samples were processed and normalized as described in Aran, Looney and
Liu et al. (2019), i.e., the raw RNA-seq counts were downloaded from 
Blueprint and ENCODE in 2016 and normalized via edgeR (TPMs).

Blueprint Epigenomics contains 144 RNA-seq pure immune samples annotated to 28 cell types.
ENCODE contains 115 RNA-seq pure stroma and immune samples annotated to 17 cell types.
All together, this reference contains 259 samples with 43 cell types (\code{"label.fine"}),
manually aggregated into 24 broad classes (\code{"label.main"}).
The fine labels have also been mapped to the Cell Ontology (\code{"label.ont"},
if \code{cell.ont} is not \code{"none"}), which can be used for further programmatic
queries.
}
\examples{
ref.se <- BlueprintEncodeData(rm.NA = "rows")

}
\references{
The ENCODE Project Consortium (2012).
An integrated encyclopedia of DNA elements in the human genome.
\emph{Nature} 489, pages 57–74.

Martens JHA and Stunnenberg HG (2013). 
BLUEPRINT: mapping human blood cell epigenomes.
\emph{Haematologica} 98, 1487–1489.

Aran D, Looney AP, Liu L et al. (2019). 
Reference-based analysis of lung single-cell sequencing reveals a transitional profibrotic macrophage.
\emph{Nat. Immunol.} 20, 163–172.
}
\author{
Friederike Dündar
}
