% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TumourMethData.R
\docType{package}
\name{TumourMethData-package}
\alias{TumourMethData}
\alias{TumourMethData-package}
\title{TumourMethData: A collection of DNA methylation datasets for human tumour
samples and matching normal samples}
\description{
TumourMethData collects tumour methylation data from a variety of different
tumour types (and also matching normal samples where available) and produced
with different technologies (e.g. WGBS, RRBS and methylation arrays) and
provides them as RangedSummarizedExperiments, facilitating easy extraction
of methylation data for regions of interest. At present, includes the
following datasets:
}
\details{
\itemize{
\item cpgea_wgbs_hg38: WGBS Data from 187 pairs of matching
human prostate tumours and normal prostate samples.
\item tcga_wgbs_hg38: WGBS Data from 39 bladder, breast,
colon, glioblastoma, lung, rectal stomach and uterine tumour samples and
and 8 matching normal samples.
\item mcrpc_wgbs_hg38: WGBS data from 100 prostate cancer metastases.
\item mcrpc_wgbs_hg38_chr11: Subset of mcrpc_wgbs_hg38 with methylation values
for just chromosome 11.
\item cao_esophageal_wgbs_hg19: WGBS data for 10 squamous esophageal tumours and
9 matching normal samples.
\item target_rhabdoid_wgbs_hg19: WGBS data for 69 childhood rhabdoid tumours.
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/richardheery/TumourMethData}
  \item Report bugs at \url{https://support.bioconductor.org/tag/TumourMethData}
}

}
\author{
Richard Heery
}
