## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(message = FALSE, warning = FALSE, error = FALSE)

## ----eval=FALSE---------------------------------------------------------------
# if (!require("BiocManager", quietly = TRUE))
#   install.packages("BiocManager")
# 
# BiocManager::install("TENxXeniumData")

## ----message=FALSE------------------------------------------------------------
library(SpatialExperiment)
library(SpatialFeatureExperiment)
library(TENxXeniumData)
library(BumpyMatrix)
library(SummarizedExperiment)

eh <- ExperimentHub()
(q <- query(eh, "TENxXenium"))

## ----message=FALSE------------------------------------------------------------
# load object
spe <- spe_mouse_brain()

# check object
spe

## -----------------------------------------------------------------------------
# here, cellular segmentations are stored in per-cell metadata 
colData(spe)

## ----message=FALSE------------------------------------------------------------
# load object
sfe <- sfe_mouse_brain()

# check object
sfe

## -----------------------------------------------------------------------------
sessionInfo()

