% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{scmmCache}
\alias{scmmCache}
\alias{setCache}
\alias{removeCache}
\title{Manage cache / download directories for study data}
\usage{
scmmCache(...)

setCache(
  directory = tools::R_user_dir("SingleCellMultiModal", "cache"),
  verbose = TRUE,
  ask = interactive()
)

removeCache(accession)
}
\arguments{
\item{...}{For \code{scmmCache}, arguments passed to \code{setCache}}

\item{directory}{\code{character(1)} The file location where the cache is located.
Once set, future downloads will go to this folder. See \code{setCache} section
for details.}

\item{verbose}{Whether to print descriptive messages}

\item{ask}{\code{logical(1)} (default TRUE when \code{interactive()}) Confirm the file
location of the cache directory}

\item{accession}{\code{character(1)} A single string indicating the accession number
of the study}
}
\value{
The directory / option of the cache location
}
\description{
Managing data downloads is important to save disk space and
re-downloading data files. This can be done effortlessly via the integrated
\code{BiocFileCache} system.
}
\section{scmmCache}{

Get the directory location of the cache. It will prompt the user to create
a cache if not already created. A specific directory can be used via
\code{setCache}.
}

\section{setCache}{

Specify the directory location of the data cache. By default, it will
go into the user's home and package name directory as given by
\link[tools:userdir]{R_user_dir} (default: varies by system e.g., for Linux:
'$HOME/.cache/R/SingleCellMultiModal').
}

\section{removeCache}{

Some files may become corrupt when downloading, this function allows
the user to delete the tarball associated with a study number in the
cache.
}

\examples{
getOption("scmmCache")
scmmCache()

}
