% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HeNSCLCData.R
\name{HeNSCLCData}
\alias{HeNSCLCData}
\title{Nanostring FFPE CosMX human NSCLC data}
\usage{
HeNSCLCData(dataset = datasets, file_path = ".", force = FALSE, verbose = TRUE)
}
\arguments{
\item{dataset}{Which dataset to use, for now can only be "Lung5_Rep1".}

\item{file_path}{Path to save downloaded files for the \code{*Output}
functions which don't return an SFE object.}

\item{force}{Logical, whether to force redownload if the files are already
present. Defaults to \code{FALSE}.}

\item{verbose}{Whether to display progress of download.}
}
\value{
A \code{SpatialFeatureExperiment} object.
}
\description{
One of the CosMX example datasets for human non small cell lung cancer
(NSCLC, Lung5_Rep1) from the
\href{https://nanostring.com/products/cosmx-spatial-molecular-imager/ffpe-dataset/}{Nanostring
website} was downloaded and formatted into an SFE object. The dataset is
described in the paper High-plex Multiomic Analysis in FFPE at Subcellular
Level by Spatial Molecular Imaging,
\href{https://doi.org/10.1101/2021.11.03.467020}{He et al}. Since there's no
easy way to get the cell segmentation polygon coordinates from the Nanostring
website, the polygon coordinates were downloaded from Seurat's vignette. The
raw count matrix, QC metrics, cell segmentation in one z-plane, and other
cell attributes such as area, aspect ratio, mean DAPI level, mean
immunofluorescence signal, and etc. are included in the SFE object.
}
