#' 
#' @title Methylation datasets from TCGA project
#'
#' @description
#' Package provides methylation (humanmethylation27) datasets from The Cancer Genome Atlas Project for
#' all cohorts types from \url{http://gdac.broadinstitute.org/}.
#' Data were downloaded using \link{RTCGA-package} and contain snapshots for
#' the date: \code{2015-11-01}. The process is described here:
#' \url{http://rtcga.github.io/RTCGA/}.
#' Use cases, examples and information about datasets in \pkg{RTCGA.data}
#' family can be found here: \code{browseVignettes("RTCGA")}. Methylation data format
#' is explained here \url{https://wiki.nci.nih.gov/display/TCGA/DNA+methylation}.
#' Converting \pkg{RTCGA.methylation} datasets from \code{data.frames} to Bioconductor classes is explained here \link{convertTCGA}.
#' 
#' @details \code{browseVignettes("RTCGA")}
#' 
#' @examples
#' 
#' \dontrun{
#' browseVignettes("RTCGA")
#' }
#'
#' 
#' @return Data frames with methylation data.
#' 
#' @import RTCGA
#' @format NULL
#' @source \url{http://gdac.broadinstitute.org/}
#' 
#' 
#' @name methylation
#' @rdname methylation
#' @aliases BRCA.methylation,COAD.methylation,COADREAD.methylation,GBM.methylation,GBMLGG.methylation,KIPAN.methylation,KIRC.methylation,KIRP.methylation,LAML.methylation,LUAD.methylation,LUSC.methylation,OV.methylation,OV.methylation1,OV.methylation2,READ.methylation,STAD.methylation,STES.methylation,UCEC.methylation
#'
"BRCA.methylation"
#' @name methylation
#' @rdname methylation
#' @format NULL
#' 
"COAD.methylation"
#' @name methylation
#' @rdname methylation
#' @format NULL
#' 
"COADREAD.methylation"
#' @name methylation
#' @rdname methylation
#' @format NULL
#' 
"GBM.methylation" 
#' @name methylation
#' @rdname methylation
#' @format NULL
#' 
"GBMLGG.methylation"  
#' @name methylation
#' @rdname methylation
#' @format NULL
#' 
"KIPAN.methylation"
#' @name methylation
#' @rdname methylation
#' @format NULL
#' 
"KIRC.methylation"    
#' @name methylation
#' @rdname methylation
#' @format NULL
#' 
"KIRP.methylation"
#' @name methylation
#' @rdname methylation
#' @format NULL
#' 
"LAML.methylation"
#' @name methylation
#' @rdname methylation
#' @format NULL
#' 
"LUAD.methylation"
#' @name methylation
#' @rdname methylation
#' @format NULL
#' 
"LUSC.methylation"
#' @name methylation
#' @rdname methylation
#' @format NULL
#' 
"OV.methylation2"      
#' @name methylation
#' @rdname methylation
#' @format NULL
#' 
"OV.methylation1" 
#' @name methylation
#' @rdname methylation
#' @format NULL
#' 
"READ.methylation"
#' @name methylation
#' @rdname methylation
#' @format NULL
#' 
"STAD.methylation"
#' @name methylation
#' @rdname methylation
#' @format NULL
#' 
"STES.methylation"
#' @name methylation
#' @rdname methylation
#' @format NULL
#' 
"UCEC.methylation"
