#' 
#' RPPA datasets from TCGA project
#'
#' Package provides RPPA datasets from The Cancer Genome Atlas Project for
#' all available cohorts types from \url{http://gdac.broadinstitute.org/}.
#' Data were downloaded using \link{RTCGA-package} and contain snapshots
#' for the date: \code{2015-11-01}. The process is described here:
#' \url{http://rtcga.github.io/RTCGA/}.
#' Use cases, examples and information about datasets in \pkg{RTCGA.data}
#' family can be found here: \code{browseVignettes("RTCGA")}. RPPA data format
#' is explained here
#' \url{https://wiki.nci.nih.gov/display/TCGA/Protein+Array+Data+Format+Specification?src=search}.
#' Converting \pkg{RTCGA.RPPA} to Bioconductor datasets' format is explained here \link{convertTCGA}.
#' 
#' @examples
#' 
#' \dontrun{
#' browseVignettes("RTCGA")
#' browseVignettes("RTCGA.RPPA")
#' }
#' 
#' @return Data frames with RPPA data.
#'
#' @import RTCGA
#' @format NULL  
#' @source \url{http://gdac.broadinstitute.org/}
#' 
#' @name RPPA
#' @rdname RPPA
#' @aliases ACC.RPPA,BLCA.RPPA,BRCA.RPPA,CESC.RPPA,CHOL.RPPA,COAD.RPPA,COADREAD.RPPA,DLBC.RPPA,ESCA.RPPA,GBM.RPPA,GBMLGG.RPPA,HNSC.RPPA,KICH.RPPA,KIPAN.RPPA,KIRC.RPPA,KIRP.RPPA,LGG.RPPA,LIHC.RPPA,LUAD.RPPA,LUSC.RPPA,MESO.RPPA,OV.RPPA,PAAD.RPPA,PCPG.RPPA,PRAD.RPPA,READ.RPPA,SARC.RPPA,SKCM.RPPA,STAD.RPPA,STES.RPPA,TGCT.RPPA,THCA.RPPA,THYM.RPPA,UCEC.RPPA,UCS.RPPA,UVM.RPPA 
#' 
"ACC.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"BLCA.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"BRCA.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"CESC.RPPA"    
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"CHOL.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"COAD.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"COADREAD.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"DLBC.RPPA"    
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"ESCA.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"GBM.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"GBMLGG.RPPA"  
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"HNSC.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"KICH.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"KIPAN.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"KIRC.RPPA"    
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"KIRP.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"LGG.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"LIHC.RPPA"    
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"LUAD.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"LUSC.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"MESO.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"OV.RPPA"      
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"PAAD.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"PCPG.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"PRAD.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"READ.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"SARC.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"SKCM.RPPA"    
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"STAD.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"STES.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"TGCT.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"THCA.RPPA"    
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"THYM.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"UCEC.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL
#' 
"UCS.RPPA"
#' @name RPPA
#' @rdname RPPA
#' @format NULL 
#' 
"UVM.RPPA"
