\name{PWMEnrich.Hsapiens.background-package}
\alias{PWMEnrich.Hsapiens.background-package}
\alias{PWMEnrich.Hsapiens.background}
\alias{MotifDb.Hsap.PFM}
\alias{MotifDb.Hsap}
\alias{PWMLogn.hg19.MotifDb.Hsap}
\alias{PWMCutoff4.hg19.MotifDb.Hsap}
\alias{PWMCutoff5.hg19.MotifDb.Hsap}
\alias{PWMGEV.hg19.MotifDb.Hsap}
\alias{PWMPvalueCutoff1e2.hg19.MotifDb.Hsap}
\alias{PWMPvalueCutoff1e3.hg19.MotifDb.Hsap}
\alias{PWMPvalueCutoff1e4.hg19.MotifDb.Hsap}
\alias{hg19.upstream2000}
\docType{package}

\title{
  PWMEnrich.Hsapiens.background package overview
}

\description{
    This package provides a set of pre-compiled genomic background files for the \code{PWMEnrich} package and H. sapiens (human). The backgrounds
  were pre-compiled using unique 2kb promoters in human. 
  
  \itemize{
  	\item \code{MotifDb.Hsap.PFM} - a list of position frequency matrices (PFMs) from \code{MotifDb}
  	
  	\item \code{MotifDb.Hsap} - the corresponding PWMs generated by using the background frequencies of A,C,G,T in a set of 2kb human (hg19) promoters. 
  	
  	\item \code{PWMLogn.hg19.MotifDb.Hsap} - pre-compiled threshold-free lognormal background for MotifDb human PWMs. 
  	The lognormal distribution is fitted to 500bp chunks of 2kb human (hg19) promoters. 
  	
  	\item \code{PWMCutoff4.hg19.MotifDb.Hsap}, \code{PWMCutoff5.hg19.MotifDb.Hsap} - pre-compiled Z-score background with cutoff of 4 and 5 (base e) for 
  	MotifDb human PWMs. The number of hits is counted in 2kb human (hg19) promoters.  
  	
  	\item \code{PWMPvalueCutoff1e2.hg19.MotifDb.Hsap}, \code{PPWMPvalueCutoff1e3.hg19.MotifDb.Hsap},
  	\code{PPWMPvalueCutoff1e4.hg19.MotifDb.Hsap} - pre-compiled Z-score background with P-value cutoff of 0.01, 0.001, and 0.0001 for 
  	MotifDb human PWMs. The number of hits with smaller P-value than cutoff is counted in 2kb human	(hg19) promoters. 
  }
}

\usage{
	data(MotifDb.Hsap.PFM)
	data(MotifDb.Hsap)
	data(PWMLogn.hg19.MotifDb.Hsap)
	data(PWMCutoff4.hg19.MotifDb.Hsap)
	data(PWMCutoff5.hg19.MotifDb.Hsap)
	data(PWMPvalueCutoff1e2.hg19.MotifDb.Hsap)
	data(PWMPvalueCutoff1e3.hg19.MotifDb.Hsap)
	data(PWMPvalueCutoff1e4.hg19.MotifDb.Hsap)
}

\details{
	All of these objects were created with the appropriate functions available in the \code{PWMEnrich} package (see Section 'See also'). We
	recommend using these functions to generate backgrounds for a custom set of background sequences and/or DNA motifs. 
	
	This package also contains the 2kb upstream sequences for human genes (\code{hg19.upstream2000}) which were removed from the BSgenome.Hsapiens.UCSC.hg19 package
	starting from Bioconductor version 3.0. 
}

\examples{
	data(PWMLogn.hg19.MotifDb.Hsap)
	
	res = motifEnrichment(DNAString("TGCATCAAGTGTGTAGTGCAAGTGAGTGATGAGTAGAAGTTGAGTGAGGTAGATGC"), 
	  PWMLogn.hg19.MotifDb.Hsap)
	
	groupReport(res)[1:10]
}

\author{
  Robert Stojnic\cr
  Cambridge Systems Biology Centre\cr
  University of Cambridge, UK

  Maintainer: Robert Stojnic \email{robert.stojnic@gmail.com}
}

\seealso{
	 \code{\link{makeBackground}}, \code{\link{makePWMLognBackground}}, \code{\link{makePWMCutoffBackground}}, \code{\link{makePWMEmpiricalBackground}}.
}

\keyword{ package }
