/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.metrics.vector;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.model.graph.G;
import slib.graph.model.graph.utils.Direction;
import slib.sml.sm.core.engine.SM_Engine;
import slib.utils.ex.SLIB_Ex_Critic;

public class VectorWeight_Chabalier_2007 {
    public static Map<URI, Double> compute(SM_Engine engine) throws SLIB_Ex_Critic {
        Logger logger = LoggerFactory.getLogger(VectorWeight_Chabalier_2007.class);
        logger.info("Computing IDF chabalier 2007");
        long nb_annotated_entities = 0L;
        Set<URI> instances = engine.getInstances();
        G g = engine.getGraph();
        HashMap<URI, Long> nbOcc = new HashMap<URI, Long>();
        for (URI v : engine.getClasses()) {
            nbOcc.put(v, new Long(0L));
        }
        for (URI o : instances) {
            for (URI v : g.getV(o, RDF.TYPE, Direction.OUT)) {
                ++nb_annotated_entities;
                nbOcc.put(v, (Long)nbOcc.get(v) + 1L);
            }
        }
        HashMap<URI, Double> stack = new HashMap<URI, Double>();
        for (URI v : engine.getClasses()) {
            double idf = Math.log(nb_annotated_entities / ((Long)nbOcc.get(v) + 1L));
            stack.put(v, idf);
        }
        return stack;
    }
}

