/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.base;

import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.openrdf.OpenRDFUtil;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.Query;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.Update;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.util.RDFInserter;
import org.openrdf.repository.util.RDFLoader;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RepositoryConnectionBase
implements RepositoryConnection {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Repository repository;
    private volatile ParserConfig parserConfig = new ParserConfig();
    private volatile boolean isOpen;

    protected RepositoryConnectionBase(Repository repository) {
        this.repository = repository;
        this.isOpen = true;
    }

    @Override
    public void setParserConfig(ParserConfig parserConfig) {
        this.parserConfig = parserConfig;
    }

    @Override
    public ParserConfig getParserConfig() {
        return this.parserConfig;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.getRepository().getValueFactory();
    }

    @Override
    public boolean isOpen() throws RepositoryException {
        return this.isOpen;
    }

    @Override
    public void close() throws RepositoryException {
        this.isOpen = false;
    }

    @Override
    public Query prepareQuery(QueryLanguage ql, String query) throws MalformedQueryException, RepositoryException {
        return this.prepareQuery(ql, query, null);
    }

    @Override
    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query) throws MalformedQueryException, RepositoryException {
        return this.prepareTupleQuery(ql, query, null);
    }

    @Override
    public GraphQuery prepareGraphQuery(QueryLanguage ql, String query) throws MalformedQueryException, RepositoryException {
        return this.prepareGraphQuery(ql, query, null);
    }

    @Override
    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query) throws MalformedQueryException, RepositoryException {
        return this.prepareBooleanQuery(ql, query, null);
    }

    @Override
    public Update prepareUpdate(QueryLanguage ql, String update) throws MalformedQueryException, RepositoryException {
        return this.prepareUpdate(ql, update, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasStatement(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        RepositoryResult<Statement> stIter = this.getStatements(subj, pred, obj, includeInferred, contexts);
        try {
            boolean bl = stIter.hasNext();
            return bl;
        }
        finally {
            stIter.close();
        }
    }

    @Override
    public boolean hasStatement(Statement st, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        return this.hasStatement(st.getSubject(), st.getPredicate(), st.getObject(), includeInferred, contexts);
    }

    @Override
    public boolean isEmpty() throws RepositoryException {
        return this.size(new Resource[0]) == 0L;
    }

    @Override
    public void export(RDFHandler handler, Resource ... contexts) throws RepositoryException, RDFHandlerException {
        this.exportStatements(null, null, null, false, handler, contexts);
    }

    @Override
    @Deprecated
    public void setAutoCommit(boolean autoCommit) throws RepositoryException {
        if (this.isActive()) {
            if (autoCommit) {
                this.commit();
            }
        } else if (!autoCommit) {
            this.begin();
        }
    }

    @Override
    @Deprecated
    public boolean isAutoCommit() throws RepositoryException {
        return !this.isActive();
    }

    @Override
    public void add(File file, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        RDFInserter rdfInserter = new RDFInserter(this);
        rdfInserter.enforceContext(contexts);
        boolean localTransaction = this.startLocalTransaction();
        try {
            RDFLoader loader = new RDFLoader(this.getParserConfig(), this.getValueFactory());
            loader.load(file, baseURI, dataFormat, (RDFHandler)rdfInserter);
            this.conditionalCommit(localTransaction);
        }
        catch (RDFHandlerException e) {
            this.conditionalRollback(localTransaction);
            throw (RepositoryException)e.getCause();
        }
        catch (RDFParseException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (IOException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (RuntimeException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    @Override
    public void add(URL url, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        RDFInserter rdfInserter = new RDFInserter(this);
        rdfInserter.enforceContext(contexts);
        boolean localTransaction = this.startLocalTransaction();
        try {
            RDFLoader loader = new RDFLoader(this.getParserConfig(), this.getValueFactory());
            loader.load(url, baseURI, dataFormat, (RDFHandler)rdfInserter);
            this.conditionalCommit(localTransaction);
        }
        catch (RDFHandlerException e) {
            this.conditionalRollback(localTransaction);
            throw (RepositoryException)e.getCause();
        }
        catch (RDFParseException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (IOException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (RuntimeException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    @Override
    public void add(InputStream in, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        RDFInserter rdfInserter = new RDFInserter(this);
        rdfInserter.enforceContext(contexts);
        boolean localTransaction = this.startLocalTransaction();
        try {
            RDFLoader loader = new RDFLoader(this.getParserConfig(), this.getValueFactory());
            loader.load(in, baseURI, dataFormat, (RDFHandler)rdfInserter);
            this.conditionalCommit(localTransaction);
        }
        catch (RDFHandlerException e) {
            this.conditionalRollback(localTransaction);
            throw (RepositoryException)e.getCause();
        }
        catch (RDFParseException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (IOException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (RuntimeException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    protected final boolean startLocalTransaction() throws RepositoryException {
        if (!this.isActive()) {
            this.begin();
            return true;
        }
        return false;
    }

    protected final void conditionalCommit(boolean condition) throws RepositoryException {
        if (condition) {
            this.commit();
        }
    }

    protected final void conditionalRollback(boolean condition) throws RepositoryException {
        if (condition) {
            this.rollback();
        }
    }

    @Override
    public void add(Reader reader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        RDFInserter rdfInserter = new RDFInserter(this);
        rdfInserter.enforceContext(contexts);
        boolean localTransaction = this.startLocalTransaction();
        try {
            RDFLoader loader = new RDFLoader(this.getParserConfig(), this.getValueFactory());
            loader.load(reader, baseURI, dataFormat, (RDFHandler)rdfInserter);
            this.conditionalCommit(localTransaction);
        }
        catch (RDFHandlerException e) {
            this.conditionalRollback(localTransaction);
            throw (RepositoryException)e.getCause();
        }
        catch (RDFParseException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (IOException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (RuntimeException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    @Override
    public void add(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        boolean localTransaction = this.startLocalTransaction();
        try {
            for (Statement statement : statements) {
                this.addWithoutCommit(statement, contexts);
            }
            this.conditionalCommit(localTransaction);
        }
        catch (RepositoryException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (RuntimeException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends Exception> void add(Iteration<? extends Statement, E> statements, Resource ... contexts) throws RepositoryException, E {
        try {
            OpenRDFUtil.verifyContextNotNull(contexts);
            boolean localTransaction = this.startLocalTransaction();
            try {
                while (statements.hasNext()) {
                    this.addWithoutCommit(statements.next(), contexts);
                }
                this.conditionalCommit(localTransaction);
            }
            catch (RepositoryException e) {
                this.conditionalRollback(localTransaction);
                throw e;
            }
            catch (RuntimeException e) {
                this.conditionalRollback(localTransaction);
                throw e;
            }
        }
        finally {
            Iterations.closeCloseable(statements);
        }
    }

    @Override
    public void add(Statement st, Resource ... contexts) throws RepositoryException {
        boolean localTransaction = this.startLocalTransaction();
        OpenRDFUtil.verifyContextNotNull(contexts);
        this.addWithoutCommit(st, contexts);
        this.conditionalCommit(localTransaction);
    }

    @Override
    public void add(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        boolean localTransaction = this.startLocalTransaction();
        OpenRDFUtil.verifyContextNotNull(contexts);
        this.addWithoutCommit(subject, predicate, object, contexts);
        this.conditionalCommit(localTransaction);
    }

    @Override
    public void remove(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        boolean localTransaction = this.startLocalTransaction();
        try {
            for (Statement statement : statements) {
                this.remove(statement, contexts);
            }
            this.conditionalCommit(localTransaction);
        }
        catch (RepositoryException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
        catch (RuntimeException e) {
            this.conditionalRollback(localTransaction);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends Exception> void remove(Iteration<? extends Statement, E> statements, Resource ... contexts) throws RepositoryException, E {
        try {
            boolean localTransaction = this.startLocalTransaction();
            try {
                while (statements.hasNext()) {
                    this.remove(statements.next(), contexts);
                }
                this.conditionalCommit(localTransaction);
            }
            catch (RepositoryException e) {
                this.conditionalRollback(localTransaction);
                throw e;
            }
            catch (RuntimeException e) {
                this.conditionalRollback(localTransaction);
                throw e;
            }
        }
        finally {
            Iterations.closeCloseable(statements);
        }
    }

    @Override
    public void remove(Statement st, Resource ... contexts) throws RepositoryException {
        boolean localTransaction = this.startLocalTransaction();
        OpenRDFUtil.verifyContextNotNull(contexts);
        this.removeWithoutCommit(st, contexts);
        this.conditionalCommit(localTransaction);
    }

    @Override
    public void remove(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        boolean localTransaction = this.startLocalTransaction();
        OpenRDFUtil.verifyContextNotNull(contexts);
        this.removeWithoutCommit(subject, predicate, object, contexts);
        this.conditionalCommit(localTransaction);
    }

    @Override
    public void clear(Resource ... contexts) throws RepositoryException {
        this.remove(null, null, null, contexts);
    }

    protected void addWithoutCommit(Statement st, Resource ... contexts) throws RepositoryException {
        if (contexts.length == 0 && st.getContext() != null) {
            contexts = new Resource[]{st.getContext()};
        }
        this.addWithoutCommit(st.getSubject(), st.getPredicate(), st.getObject(), contexts);
    }

    protected abstract void addWithoutCommit(Resource var1, URI var2, Value var3, Resource ... var4) throws RepositoryException;

    protected void removeWithoutCommit(Statement st, Resource ... contexts) throws RepositoryException {
        if (contexts.length == 0 && st.getContext() != null) {
            contexts = new Resource[]{st.getContext()};
        }
        this.removeWithoutCommit(st.getSubject(), st.getPredicate(), st.getObject(), contexts);
    }

    protected abstract void removeWithoutCommit(Resource var1, URI var2, Value var3, Resource ... var4) throws RepositoryException;
}

