/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import java.util.ArrayList;
import java.util.List;
import org.openrdf.query.algebra.ArbitraryLengthPath;
import org.openrdf.query.algebra.BinaryTupleOperator;
import org.openrdf.query.algebra.BindingSetAssignment;
import org.openrdf.query.algebra.EmptySet;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.Service;
import org.openrdf.query.algebra.SingletonSet;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UnaryTupleOperator;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.ZeroLengthPath;
import org.openrdf.query.algebra.evaluation.impl.ExternalSet;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;

public class EvaluationStatistics {
    protected CardinalityCalculator cc;

    public synchronized double getCardinality(TupleExpr expr) {
        if (this.cc == null) {
            this.cc = this.createCardinalityCalculator();
        }
        expr.visit(this.cc);
        return this.cc.getCardinality();
    }

    protected CardinalityCalculator createCardinalityCalculator() {
        return new CardinalityCalculator();
    }

    private static class ServiceNodeAnalyzer
    extends QueryModelVisitorBase<RuntimeException> {
        private int count = 0;

        private ServiceNodeAnalyzer() {
        }

        public int getStatementCount() {
            return this.count;
        }

        @Override
        public void meet(StatementPattern node) throws RuntimeException {
            ++this.count;
        }
    }

    protected static class CardinalityCalculator
    extends QueryModelVisitorBase<RuntimeException> {
        protected double cardinality;

        protected CardinalityCalculator() {
        }

        public double getCardinality() {
            return this.cardinality;
        }

        @Override
        public void meet(EmptySet node) {
            this.cardinality = 0.0;
        }

        @Override
        public void meet(SingletonSet node) {
            this.cardinality = 1.0;
        }

        @Override
        public void meet(BindingSetAssignment node) {
            this.cardinality = 0.0;
        }

        @Override
        public void meet(ZeroLengthPath node) {
            this.cardinality = 1000.0;
        }

        @Override
        public void meet(ArbitraryLengthPath node) {
            ArrayList<Var> vars = new ArrayList<Var>();
            vars.add(node.getSubjectVar());
            vars.add(node.getObjectVar());
            int constantVarCount = this.countConstantVars(vars);
            double unboundVarFactor = (double)(node.getBindingNames().size() - constantVarCount) / (double)node.getBindingNames().size();
            this.cardinality = Math.pow(1000.0, unboundVarFactor);
        }

        @Override
        public void meet(Service node) {
            if (!node.getServiceRef().hasValue()) {
                this.cardinality = 100000.0;
            } else {
                ServiceNodeAnalyzer serviceAnalyzer = new ServiceNodeAnalyzer();
                node.visitChildren(serviceAnalyzer);
                int count = serviceAnalyzer.getStatementCount();
                this.cardinality = count == 1 && node.getServiceVars().size() > 1 ? (double)(100 + node.getServiceVars().size()) : 1.0 + (double)node.getServiceVars().size() * 0.1;
            }
        }

        @Override
        public void meet(StatementPattern sp) {
            this.cardinality = this.getCardinality(sp);
        }

        protected double getCardinality(StatementPattern sp) {
            List<Var> vars = sp.getVarList();
            int constantVarCount = this.countConstantVars(vars);
            double unboundVarFactor = (double)(vars.size() - constantVarCount) / (double)vars.size();
            return Math.pow(1000.0, unboundVarFactor);
        }

        protected int countConstantVars(Iterable<Var> vars) {
            int constantVarCount = 0;
            for (Var var : vars) {
                if (!var.hasValue()) continue;
                ++constantVarCount;
            }
            return constantVarCount;
        }

        @Override
        public void meet(Join node) {
            node.getLeftArg().visit(this);
            double leftArgCost = this.cardinality;
            node.getRightArg().visit(this);
            this.cardinality *= leftArgCost;
        }

        @Override
        public void meet(LeftJoin node) {
            node.getLeftArg().visit(this);
            double leftArgCost = this.cardinality;
            node.getRightArg().visit(this);
            this.cardinality *= leftArgCost;
        }

        @Override
        protected void meetBinaryTupleOperator(BinaryTupleOperator node) {
            node.getLeftArg().visit(this);
            double leftArgCost = this.cardinality;
            node.getRightArg().visit(this);
            this.cardinality += leftArgCost;
        }

        @Override
        protected void meetUnaryTupleOperator(UnaryTupleOperator node) {
            node.getArg().visit(this);
        }

        @Override
        protected void meetNode(QueryModelNode node) {
            if (!(node instanceof ExternalSet)) {
                throw new IllegalArgumentException("Unhandled node type: " + node.getClass());
            }
            this.meetExternalSet((ExternalSet)node);
        }

        protected void meetExternalSet(ExternalSet node) {
            this.cardinality = node.cardinality();
        }
    }
}

