/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktree;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.blocktree.FieldReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.Terms;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;

public class BlockTreeTermsReader
extends FieldsProducer {
    private static long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(BlockTreeTermsReader.class);
    final IndexInput in;
    final PostingsReaderBase postingsReader;
    private final TreeMap<String, FieldReader> fields = new TreeMap();
    private long dirOffset;
    private long indexDirOffset;
    final String segment;
    private final int version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BlockTreeTermsReader(Directory dir, FieldInfos fieldInfos, SegmentInfo info, PostingsReaderBase postingsReader, IOContext ioContext, String segmentSuffix, int indexDivisor) throws IOException {
        this.postingsReader = postingsReader;
        this.segment = info.name;
        this.in = dir.openInput(IndexFileNames.segmentFileName(this.segment, segmentSuffix, "tim"), ioContext);
        boolean success = false;
        IndexInput indexIn = null;
        try {
            int numFields;
            int indexVersion;
            this.version = this.readHeader(this.in);
            if (indexDivisor != -1 && (indexVersion = this.readIndexHeader(indexIn = dir.openInput(IndexFileNames.segmentFileName(this.segment, segmentSuffix, "tip"), ioContext))) != this.version) {
                throw new CorruptIndexException("mixmatched version files: " + this.in + "=" + this.version + "," + indexIn + "=" + indexVersion);
            }
            if (indexIn != null && this.version >= 3) {
                CodecUtil.checksumEntireFile(indexIn);
            }
            postingsReader.init(this.in);
            this.seekDir(this.in, this.dirOffset);
            if (indexDivisor != -1) {
                this.seekDir(indexIn, this.indexDirOffset);
            }
            if ((numFields = this.in.readVInt()) < 0) {
                throw new CorruptIndexException("invalid numFields: " + numFields + " (resource=" + this.in + ")");
            }
            for (int i = 0; i < numFields; ++i) {
                BytesRef maxTerm;
                BytesRef minTerm;
                int longsSize;
                int field = this.in.readVInt();
                long numTerms = this.in.readVLong();
                assert (numTerms >= 0L);
                int numBytes = this.in.readVInt();
                BytesRef rootCode = new BytesRef(new byte[numBytes]);
                this.in.readBytes(rootCode.bytes, 0, numBytes);
                rootCode.length = numBytes;
                FieldInfo fieldInfo = fieldInfos.fieldInfo(field);
                assert (fieldInfo != null) : "field=" + field;
                long sumTotalTermFreq = fieldInfo.getIndexOptions() == FieldInfo.IndexOptions.DOCS_ONLY ? -1L : this.in.readVLong();
                long sumDocFreq = this.in.readVLong();
                int docCount = this.in.readVInt();
                int n = longsSize = this.version >= 2 ? this.in.readVInt() : 0;
                if (this.version >= 4) {
                    minTerm = BlockTreeTermsReader.readBytesRef(this.in);
                    maxTerm = BlockTreeTermsReader.readBytesRef(this.in);
                } else {
                    maxTerm = null;
                    minTerm = null;
                }
                if (docCount < 0 || docCount > info.getDocCount()) {
                    throw new CorruptIndexException("invalid docCount: " + docCount + " maxDoc: " + info.getDocCount() + " (resource=" + this.in + ")");
                }
                if (sumDocFreq < (long)docCount) {
                    throw new CorruptIndexException("invalid sumDocFreq: " + sumDocFreq + " docCount: " + docCount + " (resource=" + this.in + ")");
                }
                if (sumTotalTermFreq != -1L && sumTotalTermFreq < sumDocFreq) {
                    throw new CorruptIndexException("invalid sumTotalTermFreq: " + sumTotalTermFreq + " sumDocFreq: " + sumDocFreq + " (resource=" + this.in + ")");
                }
                long indexStartFP = indexDivisor != -1 ? indexIn.readVLong() : 0L;
                FieldReader previous = this.fields.put(fieldInfo.name, new FieldReader(this, fieldInfo, numTerms, rootCode, sumTotalTermFreq, sumDocFreq, docCount, indexStartFP, longsSize, indexIn, minTerm, maxTerm));
                if (previous == null) continue;
                throw new CorruptIndexException("duplicate field: " + fieldInfo.name + " (resource=" + this.in + ")");
            }
            if (indexDivisor != -1) {
                indexIn.close();
            }
            if (success = true) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(indexIn, this);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(indexIn, this);
    }

    private static BytesRef readBytesRef(IndexInput in) throws IOException {
        BytesRef bytes = new BytesRef();
        bytes.length = in.readVInt();
        bytes.bytes = new byte[bytes.length];
        in.readBytes(bytes.bytes, 0, bytes.length);
        return bytes;
    }

    protected int readHeader(IndexInput input) throws IOException {
        int version = CodecUtil.checkHeader(input, "BLOCK_TREE_TERMS_DICT", 0, 4);
        if (version < 1) {
            this.dirOffset = input.readLong();
        }
        return version;
    }

    protected int readIndexHeader(IndexInput input) throws IOException {
        int version = CodecUtil.checkHeader(input, "BLOCK_TREE_TERMS_INDEX", 0, 4);
        if (version < 1) {
            this.indexDirOffset = input.readLong();
        }
        return version;
    }

    protected void seekDir(IndexInput input, long dirOffset) throws IOException {
        if (this.version >= 3) {
            input.seek(input.length() - (long)CodecUtil.footerLength() - 8L);
            dirOffset = input.readLong();
        } else if (this.version >= 1) {
            input.seek(input.length() - 8L);
            dirOffset = input.readLong();
        }
        input.seek(dirOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            IOUtils.close(this.in, this.postingsReader);
        }
        finally {
            this.fields.clear();
        }
    }

    @Override
    public Iterator<String> iterator() {
        return Collections.unmodifiableSet(this.fields.keySet()).iterator();
    }

    @Override
    public Terms terms(String field) throws IOException {
        assert (field != null);
        return this.fields.get(field);
    }

    @Override
    public int size() {
        return this.fields.size();
    }

    String brToString(BytesRef b) {
        if (b == null) {
            return "null";
        }
        try {
            return b.utf8ToString() + " " + b;
        }
        catch (Throwable t) {
            return b.toString();
        }
    }

    @Override
    public long ramBytesUsed() {
        long sizeInByes = BASE_RAM_BYTES_USED + (this.postingsReader != null ? this.postingsReader.ramBytesUsed() : 0L) + (long)this.fields.size() * 2L * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        for (FieldReader reader : this.fields.values()) {
            sizeInByes += reader.ramBytesUsed();
        }
        return sizeInByes;
    }

    @Override
    public void checkIntegrity() throws IOException {
        if (this.version >= 3) {
            CodecUtil.checksumEntireFile(this.in);
            this.postingsReader.checkIntegrity();
        }
    }
}

