% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bt2_16S_params}
\alias{bt2_16S_params}
\title{A universal parameter object for Bowtie 2 16S alignment}
\format{
list
}
\usage{
data(bt2_16S_params)
}
\description{
This character string provides several Bowtie 2 options to provide an
optimized alignment specifically optimized for 16S amplicon sequencing data.
This object can be used with functions that use the Bowtie 2 aligner through
the \code{Rbowtie2} package, namely \code{align_target_bowtie()} and
\code{filter_host_bowtie}. These settings can be substituted for default
settings by passing \code{} to the \code{bowtie2_options} argument.
}
\details{
The default parameters listed in this object are
"--local -R 2 -N 0 -L 25 -i S,1,0.75 -k 5 --score-min L,0,1.88"

Note that k is actually 10 and is doubled internally from 5.
The \code{score-min} function was chosen such that the minimum alignment score
allowed requires 98% identity.

Further delineation of Bowtie 2 parameters is provided in the
\href{https://bowtie-bio.sourceforge.net/bowtie2/manual.shtml}{Bowtie 2
manual}.
}
\examples{
data("bt2_16S_params")

}
\keyword{datasets}
