% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align_target.R
\name{align_target}
\alias{align_target}
\title{Align microbiome reads to a set of reference libraries}
\usage{
align_target(
  read1,
  read2 = NULL,
  lib_dir = NULL,
  libs,
  threads = 1,
  align_file = tools::file_path_sans_ext(read1),
  subread_options = align_details,
  quiet = TRUE
)
}
\arguments{
\item{read1}{Path to the .fastq file to align.}

\item{read2}{Optional: Location of the mate pair .fastq file to align.}

\item{lib_dir}{Path to the index files for all libraries.}

\item{libs}{A vector of character strings giving the basenames of the Subread
index files for alignment. If ALL indices to be used are located in the
current working directory, set \code{lib_dir = NULL}. Default is
\code{lib_dir = NULL}.}

\item{threads}{The number of threads that can be utilized by the function.
Default is 1 thread.}

\item{align_file}{The basename of the output alignment file (without trailing
.bam extension).}

\item{subread_options}{A named \code{list} specifying alignment parameters
for the \code{Rsubread::align()} function, which is called inside
\code{align_target()}. Elements should include type, nthreads,
maxMismatches, nsubreads, phredOffset, unique, and nBestLocations.
Descriptions of these parameters are available under
\code{?Rsubread::align}. Defaults to the global \code{align_details}
object.}

\item{quiet}{Turns off most messages. Default is \code{TRUE}.}
}
\value{
This function writes a merged and sorted .bam file after aligning to
all reference libraries given, along with a summary report file, to the
user's working directory. The function also outputs the new .bam filename.
}
\description{
This is the main MetaScope target library mapping function, using Rsubread
and multiple libraries. Aligns to each library separately, filters unmapped
reads from each file, and then merges and sorts the .bam files from each
library into one output file. If desired, output can be passed to
`filter_host()` to remove reads that also map to filter library genomes.
}
\examples{
#### Align example reads to an example reference library using Rsubread
\donttest{
## Create temporary directory
target_ref_temp <- tempfile()
dir.create(target_ref_temp)

tax <- "Ovine atadenovirus D"

## Create temporary taxonomizr accession
tmp_accession <- system.file("extdata", "example_accessions.sql", package = "MetaScope")

## Download genome
all_ref <- MetaScope::download_refseq(tax,
                                      reference = FALSE,
                                      representative = FALSE,
                                      compress = TRUE,
                                      out_dir = target_ref_temp,
                                      caching = TRUE,
                                      accession_path = tmp_accession)

## Create subread index
ind_out <- mk_subread_index(all_ref)

## Get path to example reads
readPath <- system.file("extdata", "reads.fastq",
                        package = "MetaScope")
## Copy the example reads to the temp directory
refPath <- file.path(target_ref_temp, "reads.fastq")
file.copy(from = readPath, to = refPath)

## Modify alignment parameters object
data("align_details")
align_details[["type"]] <- "rna"
align_details[["phredOffset"]] <- 50
# Just to get it to align - toy example!
align_details[["maxMismatches"]] <- 100

## Run alignment
target_map <- align_target(refPath,
                           libs = stringr::str_replace_all(tax, " ", "_"),
                           lib_dir = target_ref_temp,
                           subread_options = align_details)

## Remove temporary folder
unlink(target_ref_temp, recursive = TRUE)
}
}
