% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plotXY}
\alias{plotXY}
\title{Plot spatial image with data overlay}
\usage{
plotXY(df, col, img = NULL)
}
\arguments{
\item{df}{A \code{data.frame} storing the data to plot.}

\item{col}{character. A column of \code{df} to use for overlay onto the image.}

\item{img}{a raster object representing a bitmap image.}
}
\value{
A ggplot.
}
\description{
A helper function to overlay data onto a spatial image.
}
\examples{
 gene <- rep(c("Cd44", "Cd8b1", "Cd79b"), each = 2)
 x <- c(1693, 1701, 1820, 3188, 1631, 1881)
 y <- c(1831, 1666, 1855, 6612, 1533, 942)
 df <- data.frame(gene = gene, x = x, y = y)
 plotXY(df, "gene")
}
