% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{addHolesToPolygons}
\alias{addHolesToPolygons}
\title{Add holes to polygons}
\usage{
addHolesToPolygons(poly)
}
\arguments{
\item{poly}{A \code{data.frame} storing cell polygon coordinates.
Expected columns include \itemize{
\item \code{"cell"} storing the cell ID,
\item \code{"x"} storing x-coordinates of the polygon corners,
\item \code{"y"} storing the y-coordinates of the polygon corners.}}
}
\value{
A \code{data.frame}
}
\description{
Add holes to a \code{data.frame} of cell polygon coordinates
}
\examples{
     x <- c(2053, 2053, 2053, 2056, 2059, 2059)
     y <- c(51, 54, 57, 57, 57, 54)
     poly <- data.frame(cell = 1, x = x, y = y)
     poly <- addHolesToPolygons(poly)
}
