% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ileum.R
\name{MouseIleumPetukhov2021}
\alias{MouseIleumPetukhov2021}
\title{MERFISH mouse ileum dataset from Petukhov et al., 2021}
\source{
\url{https://doi.org/10.5061/dryad.jm63xsjb2}
}
\usage{
MouseIleumPetukhov2021(
  segmentation = c("baysor", "cellpose"),
  use.images = TRUE,
  use.polygons = TRUE
)
}
\arguments{
\item{segmentation}{character. Should be either \code{"baysor"} or
\code{"cellpose"}. Defaults to \code{"baysor"}. See details.}

\item{use.images}{logical. Should DAPI and Membrane Na+/K+ - ATPase images
be loaded into memory and annotated to the \code{\link{imgData}} slot of
the returned \code{\linkS4class{SpatialExperiment}}? Defaults to \code{TRUE}.
See details.}

\item{use.polygons}{logical. Should polygon cell boundaries be annotated
to the \code{\link{metadata}} of the returned \code{\linkS4class{SpatialExperiment}}?
Defaults to \code{TRUE}. Only available for Baysor segmentation.}
}
\value{
An object of class \code{\linkS4class{SpatialExperiment}}.
}
\description{
Obtain the MERFISH mouse ileum dataset from Petukhov et al., 2021
}
\details{
Spatial transcriptomics protocols based on in situ sequencing or
multiplexed RNA fluorescent hybridization can reveal detailed tissue organization.
Distinguishing the boundaries of individual cells in such data is challenging.
Current segmentation methods typically approximate cells positions using nuclei
stains.

Petukhov et al., 2021, describe Baysor, a segmentation method,
which optimizes 2D or 3D cell boundaries considering joint likelihood of
transcriptional composition and cell morphology.
Baysor can also perform segmentation based on the detected transcripts alone.

Petukhov et al., 2021, compare the results of Baysor segmentation (mRNA-only)
to the results of a deep learning-based segmentation method called Cellpose from
Stringer et al., 2021. Cellpose applies a machine learning framework for the
segmentation of cell bodies, membranes and nuclei from microscopy images.

The function allows to obtain segmented MERFISH mouse ileum data for both
segmentation methods.

A note on storing images within a \code{\linkS4class{SpatialExperiment}}:
The default \code{use.images = TRUE} reduces the 9-frame z-stack images
for DAPI stain and Membrane Na+/K+ - ATPase fluorecense to single-frame
images (taking the first frame). For working with the 9-frame z-stack
images it is recommended to load the images individually from ExperimentHub.
}
\examples{
spe <- MouseIleumPetukhov2021()
}
\references{
Petukhov et al. (2021) Cell segmentation in imaging-based
spatial transcriptomics. Nat Biotechnol, 40(3), 345-54.

Stringer et al. (2021) Cellpose: a generalist algorithm for cellular
segmentation.  Nat Methods, 18(1), 100-6.
}
