% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothalamus.R
\name{MouseHypothalamusMoffitt2018}
\alias{MouseHypothalamusMoffitt2018}
\title{MERFISH mouse hypothalamus dataset from Moffitt et al., 2018}
\source{
\url{https://doi.org/10.5061/dryad.8t8s248}
}
\usage{
MouseHypothalamusMoffitt2018(center.coords = TRUE)
}
\arguments{
\item{center.coords}{logical. Should spatial x- and y-coordinates be centered
for each z-layer (bregma slice)? This is useful for making coordinates
comparable between bregma slices for visualization and analysis.
Defaults to \code{TRUE}. Use \code{FALSE} to obtain the coordinates as
provided in the data release.}
}
\value{
An object of class \code{\linkS4class{SpatialExperiment}}.
}
\description{
Obtain the MERFISH mouse hypothalamic preoptic region dataset
from Moffitt et al., 2018
}
\details{
The hypothalamus controls essential social behaviors and homeostatic
functions. However, the cellular architecture of hypothalamic nuclei, including
the molecular identity, spatial organization, and function of distinct cell
types, is not well understood.

Moffitt et al., 2018, developed an imaging-based cell type identification and
mapping method and combined it with single-cell RNA-sequencing to create a
molecularly annotated and spatially resolved cell atlas of the mouse hypothalamic
preoptic region.

The MERFISH measurements were obtained via combinatorial smFISH imaging for
135 genes (main experiment named \code{"smFISH"}), followed by sequential rounds
of non-combinatorial seqFISH for 20 additional genes (stored as an \code{altExp}
named \code{"seqFISH"}). These genes were considered neuronal markers and important
for discriminating neuronal cell populations. For behavioral measurements,
cFos was added to the set of genes measured with sequential rounds of FISH.

The barcoding scheme contained 140 possible barcodes; 135 of them were used to
code the RNAs of the genes assayed via combinatorial smFISH; 5 of these barcodes
were left unassigned ("blank"), providing a direct measure of the false-positive
rate in MERFISH. Measurements for these 5 blank barcodes is stored in an
\code{altExp} named \code{"blank"}.
}
\examples{
spe <- MouseHypothalamusMoffitt2018()
}
\references{
Moffitt et al. (2018) Molecular, spatial, and functional
single-cell profiling of the hypothalamic preoptic region.
Science, 362(6416), eaau5324.
}
