% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_lm_model.R
\name{run_lm_model}
\alias{run_lm_model}
\title{Compute linear models (LM) on microbiome data}
\usage{
run_lm_model(
  dat,
  taxon_level = "genus",
  fixed_cov,
  p_adj_method = "fdr",
  plot_out = FALSE,
  plotsave_loc = ".",
  plot_terms = NULL,
  ...
)
}
\arguments{
\item{dat}{A MultiAssayExperiment object specially formatted as an animalcules output.}

\item{taxon_level}{Character string, default is \code{"genus"}.}

\item{fixed_cov}{A character vector naming covariates to be tested.}

\item{p_adj_method}{A character string specifying the correction method. Can
be abbreviated. See details. Default is \code{"fdr"}.}

\item{plot_out}{Logical indicating whether plots should be output alongside
the model results. Default is \code{FALSE}.}

\item{plotsave_loc}{A character string giving the folder path to save plot
outputs. This defaults to the current working directory.}

\item{plot_terms}{Character vector. Which terms should be examined in the
plot output? Can overlap with the \code{fixed_cov} inputs.}

\item{...}{Further arguments passed to \code{ggsave} for plot creation.}
}
\value{
A \code{data.frame} of modeling results.
}
\description{
This function takes an animalcules-formatted \code{MultiAssayExperiment} and
runs an independent linear model for each taxon. The model predicts taxon log
CPM abundance as a product of user-specified covariates. This model can
be used for general microbiome analyses without repeated measures data.
Note, the "broom", and
"broom.mixed" packages are required to use the testing functionality of this
package; both can be installed via CRAN.
}
\details{
P-values are adjusted for the model coefficients within each taxon. The
following methods are permitted: \code{c("holm", "hochberg", "hommel",
"bonferroni", "BH", "BY", "fdr", "none")}
}
\examples{
dat <- system.file("extdata/MAE.RDS", package = "LegATo") |>
  readRDS() |>
  filter_MAE()
out <- run_lm_model(dat, fixed_cov = c("timepoint", "HIVStatus"),
                    plot_out = FALSE)
head(out)

}
