% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{wasserman_normal_sim}
\alias{wasserman_normal_sim}
\alias{wasserman_normal_sim_fun}
\title{Normal simulation: Covariate is effect size under alternative}
\usage{
wasserman_normal_sim(m, pi0, xi_min, xi_max, seed = NULL)

wasserman_normal_sim_fun(m, pi0, xi_min, xi_max)
}
\arguments{
\item{m}{Integer, total number of hypotheses}

\item{pi0}{Numeric, proportion of null hypotheses}

\item{xi_min, xi_max}{Numeric, covariates are drawn as uniform on xi_min, xi_max}

\item{seed}{Integer, Random seed to be used for simulation 
(default: NULL, i.e. RNG state will be used as is)}
}
\value{
A data frame containing all information about the simulation experiment
}
\description{
Normal simulation: Covariate is effect size under alternative
}
\section{Functions}{
\itemize{
\item \code{wasserman_normal_sim_fun}: Creates a closure function for a given seed
}}

\examples{
sim_df <- wasserman_normal_sim(20000,0.9, 1, 5)

}
