% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratified_methods.R
\name{stratified_bh}
\alias{stratified_bh}
\title{stratified_bh: Stratified Benjamini Hochberg}
\usage{
stratified_bh(unadj_p, groups, alpha)
}
\arguments{
\item{unadj_p}{Numeric vector of unadjusted p-values.}

\item{groups}{Factor to which different hypotheses belong}

\item{alpha}{Significance level at which to apply method}
}
\value{
SBH multiple testing object
}
\description{
stratified_bh: Stratified Benjamini Hochberg
}
\examples{
     sim_df <- du_ttest_sim(20000,0.95, 1.5)
     sim_df$group <- groups_by_filter(sim_df$filterstat, 20)
     obj <- stratified_bh(sim_df$pvalue, sim_df$group, .1)
     sum(rejected_hypotheses(obj))

}
\references{
Sun, Lei, et al. "Stratified false discovery control for large-scale hypothesis testing with application to genome-wide
   association studies." Genetic epidemiology 30.6 (2006): 519-530.

Yoo, Yun J., et al. "Were genome-wide linkage studies a waste of time? Exploiting candidate regions within genome-wide
   association studies." Genetic epidemiology 34.2 (2010): 107-118.
}
