% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddhw_wrappers.R
\name{ihw_naive}
\alias{ihw_naive}
\alias{ihw_ecdf_5fold}
\alias{ihw_5fold}
\alias{ihw_5fold_reg}
\alias{ihw_bonf_5fold_reg}
\alias{ihw_storey_5fold}
\title{IHW wrappers}
\usage{
ihw_naive(unadj_p, filterstat, alpha)

ihw_ecdf_5fold(unadj_p, filterstat, alpha)

ihw_5fold(unadj_p, filterstat, alpha)

ihw_5fold_reg(unadj_p, filterstat, alpha)

ihw_bonf_5fold_reg(unadj_p, filterstat, alpha)

ihw_storey_5fold(unadj_p, filterstat, alpha)
}
\arguments{
\item{unadj_p}{Numeric vector of unadjusted p-values.}

\item{filterstat}{Factor to which different hypotheses belong}

\item{alpha}{Significance level at which to apply method}
}
\value{
ihwResult multiple testing object
}
\description{
IHW wrappers
}
\details{
These are closures, which apply IHW with custom
  prespecified parameters. These correspond to interesting
  settings, for which it is convenient to be able to immediately
  call the corresponding functions, rather than having to specify
  parameters each time. Thus they make it easier to benchmark.
  All of these wrappers are defined in 2 lines of code, 
  so the settings pertaining
  to each one can be inspected by typing the functions name into the
  console.
}
\section{Functions}{
\itemize{
\item \code{ihw_naive}: IHW naive

\item \code{ihw_ecdf_5fold}: IHW (E2) with 5 folds

\item \code{ihw_5fold}: IHW (E1-E2) with 5 folds

\item \code{ihw_5fold_reg}: IHW (E1-E2-E3) with 5 folds

\item \code{ihw_bonf_5fold_reg}: IHW-Bonferroni (E1-E2-E3) with 5 folds

\item \code{ihw_storey_5fold}: IHW (E1-E2) with 5 folds and Storey's pi0 estimator
}}

\examples{
     sim_df <- du_ttest_sim(20000,0.95, 1.5)
     obj <- ihw_5fold(sim_df$pvalue, sim_df$filterstat, .1)
     sum(rejected_hypotheses(obj))

}
