% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratified_methods.R
\name{gbh}
\alias{gbh}
\alias{tst_gbh}
\alias{lsl_gbh}
\title{gbh: Grouped Benjamini Hochberg}
\usage{
gbh(unadj_p, groups, alpha, method = "TST", pi0_global = "weighted_average")

tst_gbh(unadj_p, groups, alpha, ...)

lsl_gbh(unadj_p, groups, alpha, ...)
}
\arguments{
\item{unadj_p}{Numeric vector of unadjusted p-values.}

\item{groups}{Factor to which different hypotheses belong}

\item{alpha}{Significance level at which to apply method}

\item{method}{What pi0 estimator should be used (available "TST","LSL")}

\item{pi0_global}{GBH requires also a pi0 estimate for the marginal p-value distribution. Can either apply pi0 estimation method to
all p-values (pi0_global="global") or use a weigted averarage (pi0_global="weighted_average") of the pi0 estimates within each stratum.
This is not explicitly stated in the paper, but based on a reproduction of their paper figures it seems to be the weighted_average.}

\item{...}{Additional arguments passed from tst_gbh/lsl_gbh to gbh}
}
\value{
GBH multiple testing object
}
\description{
gbh: Grouped Benjamini Hochberg

tst_gbh: wrapper for gbh with method="TST"
lsl_gbh: wrapper for gbh with method="LSL"
}
\section{Functions}{
\itemize{
\item \code{tst_gbh}: Wrapper of GBH with TST pi0 estimator

\item \code{lsl_gbh}: Wrapper of GBH with LSL pi0 estimator
}}

\examples{
     sim_df <- du_ttest_sim(20000,0.95, 1.5)
     sim_df$group <- groups_by_filter(sim_df$filterstat, 20)
     obj <- tst_gbh(sim_df$pvalue, sim_df$group, .1)
     sum(rejected_hypotheses(obj))

}
\references{
Hu, James X., Hongyu Zhao, and Harrison H. Zhou. "False discovery rate control with groups." 
        Journal of the American Statistical Association 105.491 (2010).
}
