% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratified_methods.R
\name{clfdr}
\alias{clfdr}
\title{clfdr: Cai's local fdr based method}
\usage{
clfdr(unadj_p, groups, alpha, lfdr_estimation = "fdrtool")
}
\arguments{
\item{unadj_p}{Numeric vector of unadjusted p-values.}

\item{groups}{Factor to which different hypotheses belong}

\item{alpha}{Significance level at which to apply method}

\item{lfdr_estimation}{Method used to estimate the loca fdr, defaults to "fdrtool"}
}
\value{
Clfdr multiple testing object
}
\description{
clfdr: Cai's local fdr based method
}
\examples{
     sim_df <- du_ttest_sim(20000,0.95, 1.5)
     sim_df$group <- groups_by_filter(sim_df$filterstat, 20)
     obj <- clfdr(sim_df$pvalue, sim_df$group, .1)
     sum(rejected_hypotheses(obj))

}
\references{
Cai, T. Tony, and Wenguang Sun. "Simultaneous testing of grouped hypotheses: Finding needles in multiple haystacks." 
          Journal of the American Statistical Association 104.488 (2009).
}
