% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HarmanData.R
\docType{data}
\name{episcope}
\alias{episcope}
\title{Infinium Methylation BeadChip batch correction reference data}
\format{
A list with 6 entities:
\describe{
  \item{pd}{Phenotypic descriptors for the 369 samples}
  \item{original}{Original uncorrected data from the study}
  \item{harman}{Harman corrected data}
  \item{combat}{ComBat corrected data}
  \item{ref_lvr}{Reference log2 variance ratios for the 11 probes}
  \item{ref_md}{Reference mean difference in beta for the 11 probes}
}
}
\usage{
data(episcope)
}
\value{
\code{\link{promise}}
}
\description{
A reference dataset containing beta values spanning 11 CpG
probesets from the 369 arrays of the EpiSCOPE study (van Dijk, 2106). The
450K methylation data arises from neonate blood spots from children enrolled
in the DOMInO (DHA to Optimise Mother Infant Outcome) cohort.
}
\details{
Example beta values from the EpiSCOPE study
}
\examples{
library(Harman)
data(episcope)
bad_batches <- c(1, 5, 9, 17, 25)
is_bad_sample <- episcope$pd$array_num \%in\% bad_batches
myK <- discoverClusteredMethylation(episcope$original[, !is_bad_sample])
mykClust = kClusterMethylation(episcope$original, row_ks=myK)
res = clusterStats(pre_betas=episcope$original,
                   post_betas=episcope$harman,
                   kClusters = mykClust)
all.equal(episcope$ref_md$meandiffs_harman, res$meandiffs)
all.equal(episcope$ref_lvr$var_ratio_harman, res$log2_var_ratio)
}
\references{
\url{https://doi.org/10.1186/s13148-016-0281-7/}
}
