% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listTestFiles.R
\name{listTestFiles}
\alias{listTestFiles}
\alias{getTestFile}
\title{List available test files}
\usage{
listTestFiles(
  hub = ExperimentHub(),
  dataset = NULL,
  version = NULL,
  latest = TRUE
)

getTestFile(path, hub = ExperimentHub(), prefix = TRUE)
}
\arguments{
\item{hub}{An \linkS4class{ExperimentHub} object.}

\item{dataset}{String specifying the dataset to search for, e.g., \code{"tenx-2.1.0-pbmc4k"}.
By default, files are listed for all datasets.}

\item{version}{String specifying the version of the files to search for.}

\item{latest}{Logical scalar indicating whether the latest version of each file should be presented.
Only used if \code{version=NULL}; if \code{FALSE}, entries are returned for all versions.}

\item{path}{String containing the \code{RDataPath} of the resource of interest.}

\item{prefix}{Logical scalar indicating whether \code{path} should be prefixed with \code{"DropletTestFiles/"}.}
}
\value{
A \linkS4class{DataFrame} containing information on all relevant test files (one per row).
Of particular interest are the columns \code{file.dataset}, \code{file.version} and \code{file.name},
containing the dataset, version and name of each test file.
}
\description{
List all test files managed by \pkg{DropletTestFiles} on \pkg{ExperimentHub}.
}
\details{
Versions refer to those of the \pkg{DropletTestFiles} package itself,
and refer to the version of the package in which a particular dataset was added.
}
\examples{
# Getting everything:
listTestFiles()

# Getting all files for a particular dataset.
out <- listTestFiles(dataset="tenx-3.1.0-5k_pbmc_protein_v3")
out

# Downloading a resource to a local file, using an EH number:
library(ExperimentHub)
hub <- ExperimentHub()
hub[[rownames(out)[1]]]

# Downloading the same resource using an RDataPath:
getTestFile(out$rdatapath[1], prefix=FALSE)

}
\author{
Aaron Lun
}
