% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc-data.R
\docType{data}
\name{Exp2_R100_prot}
\alias{Exp2_R100_prot}
\title{Exp2_R100_prot dataset}
\format{
An object of class \code{MSnSet} related to proteins
quantification. It contains 6 samples divided into two conditions
(1 fmol and 100 fmol) and 923 proteins.

The data frame exprs(Exp2_R100_prot) contains six columns that are the 
quantitation of proteins for the six replicates. 

The data frame fData(Exp2_R100_prot) contains the meta data about the 
proteins.

The data frame pData(Exp2_R100_prot) contains the experimental design and 
gives few informations about the samples.
}
\usage{
data(Exp2_R100_prot)
}
\value{
An object of class \code{MSnSet} related to proteins
quantification.
}
\description{
This dataset is the final outcome of a quantitative mass 
spectrometry-based proteomic analysis of two samples containing different 
concentrations of 48 human proteins (UPS1 standard from Sigma-Aldrich) 
within a constant yeast background (see Ramus et al. (2015) for 
details). It contains the abundance values of the different human and 
yeast peptides identified and quantified in these two conditions. The two 
conditions represent the measured abundances of peptides when respectively 
1 fmol and 100 fmol of UPS1 human proteins were mixed with the yeast extract 
before mass spectrometry analyses. This results in a concentration ratio 
of 100. Three technical replicates were acquired for each condition.


The dataset is either available as a CSV file 
(see inst/extdata/Exp2_R100_prot.txt), or as a \code{MSnSet} 
structure (Exp2_R100_prot.MSnset). In the latter case, the quantitative 
data are those of the raw intensities.
}
\references{
Ramus C, Hovasse A, Marcellin M, Hesse AM, Mouton-Barbosa E, Bouyssie D, 
Vaca S, Carapito C, Chaoui K, Bruley C, Garin J, Cianferani S, Ferro M, 
Dorssaeler AV, Burlet-Schiltz O, Schaeffer C, Coute Y, Gonzalez de Peredo A.
Spiked proteomic standard dataset for testing label-free quantitative 
software and statistical methods. Data Brief. 2015 Dec 17;6:286-94.
PMID: 26862574.
}
\keyword{data}
\keyword{datasets}
