% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proteome.R
\name{ccleProteome2SummarizedExperiment}
\alias{ccleProteome2SummarizedExperiment}
\title{Convenient access to the CCLE proteome data}
\usage{
ccleProteome2SummarizedExperiment(df, cell.line = "HCT116")
}
\arguments{
\item{df}{a \code{data.frame} storing the CCLE protein expression data with
one measurement in each row. Typically obtained from \code{ExperimentHub}.
See examples.}

\item{cell.line}{character. One or more cell line IDs such as \code{"HCT116"}
(human colon cancer cell line 116). Use \code{NULL} to not subset by cell line.
Defaults to \code{"HCT116"}, which will then subset the df to measurements for
HCT116 only.}
}
\value{
A \code{\linkS4class{SummarizedExperiment}} storing protein expression
data for the specified cell line(s).
}
\description{
Functionality for storing the protein expression data
from the Cancer Cell Line Encyclopedia (CCLE) in a
\code{\linkS4class{SummarizedExperiment}}.
}
\examples{

  # Connect to ExperimentHub
  eh <- ExperimentHub::ExperimentHub()

  # Obtain CCLE proteome data frame
  AnnotationHub::query(eh, c("gygi", "depmap"))
  ccle.prot <- eh[["EH3459"]]
  ccle.prot <- as.data.frame(ccle.prot)

  # Turn into a SummarizedExperiment
  se <- ccleProteome2SummarizedExperiment(ccle.prot)
  
}
\references{
CCLE proteomics: \url{https://gygi.hms.harvard.edu/publications/ccle.html}
}
