% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corum.R
\name{hasSubunit}
\alias{hasSubunit}
\title{Identify CORUM complexes that have a subunit of interest}
\usage{
hasSubunit(glist, subunit, id.type = "SYMBOL")
}
\arguments{
\item{glist}{A \code{list} of \code{graph}s storing CORUM complexes.
Typically obtained via \code{\link{corum2graphlist}}.}

\item{subunit}{character. A gene ID corresponding to the subunit of interest.}

\item{id.type}{character. Gene ID type of the given subunit. Defaults to \code{"SYMBOL"}.}
}
\value{
A logical vector indicating which graphs have a node with the given
subunit.
}
\description{
Screens a \code{list} of \code{graph} instances storing
CORUM protein complex data for a subunit of choice.
}
\examples{
# (1) Obtain the core set of CORUM complexes ...
core <- getCorum(set = "core")

# (2) ... turn into a list of graphs ...
core.glist <- corum2graphlist(core)

# (3) .. check for a particular subunit of interest
has.cdk2 <- hasSubunit(core.glist, subunit = "CDK2")
}
