% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneInfo.R
\name{getGeneInfoByIDs}
\alias{getGeneInfoByIDs}
\title{Get GeneInfo table for set of GeneIDs}
\usage{
getGeneInfoByIDs(ids)
}
\arguments{
\item{ids}{\code{vector} of Gene IDs.}
}
\value{
\code{data.frame} with column specified above.
}
\description{
Function lookup for internal GeneID values and return following
features for all found genes:
GeneID (internal database ID), Localisation (one of the following:
presynaptic, postsynaptic, synaptosome),
MGI (MGI ID), HumanEntrez (Human Entrez ID), MouseEntrez (Mouse Entrez ID),
HumanName (Human gene name), MouseName (Mouse gene name),
PaperPMID (PMID IDs for the publications where the genes were reported),
Paper (papers where specific genes were reported in a format
FIRSTAUTHOR_YEAR), Year, SpeciesTaxID (specie the original experiment
was performed on), BrainRegion (Brain region where the specific genes
were identified, according to the paper)
}
\details{
This function then returns
following features for all found genes:
\itemize{
\item GeneID,
\item Localisation,
\item MGI,
\item HumanEntrez,
\item MouseEntrez,
\item HumanName,
\item MouseName,
\item PaperPMID,
\item Paper,
\item Year,
\item SpeciesTaxID,
\item BrainRegion
}
}
\examples{
gdf <- getGeneInfoByIDs(c(46, 6, 15, 1))
}
\seealso{
Other {GeneInfo functions}: 
\code{\link{getGeneInfoByEntrez}()},
\code{\link{getGeneInfoByName}()},
\code{\link{getGeneInfoByPapers}()}
}
\concept{{GeneInfo functions}}
