% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diseases.R
\name{getGeneDiseaseByEntres}
\alias{getGeneDiseaseByEntres}
\title{Disease information for Human Entrez IDs}
\usage{
getGeneDiseaseByEntres(entrez)
}
\arguments{
\item{entrez}{\code{vector} of Human Entrez gene IDs}
}
\value{
data.frame with following columns:
\itemize{
\item HumanEntrez
\item HumanName
\item HDOID
\item Description
}
}
\description{
Get Human disease information (HDO provided) for the set of
Human Entrez IDs. Function lookups for diseases associated with
Human Entrez IDs and returns list of available diseases.
}
\examples{
t <- getGeneDiseaseByEntres(c(8573, 1742, 1739)) # (95 rows)
}
\seealso{
Other {Disease functions}: 
\code{\link{getGeneDiseaseByIDs}()},
\code{\link{getGeneDiseaseByName}()}
}
\concept{{Disease functions}}
