% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brain_regions.R
\name{getAllGenes4BrainRegion}
\alias{getAllGenes4BrainRegion}
\title{Get all genes for brain region for particular specie}
\usage{
getAllGenes4BrainRegion(brainRegion, taxID)
}
\arguments{
\item{brainRegion}{ID for specific brain region}

\item{taxID}{specie ID}
}
\value{
data.frame with the following columns:
\itemize{
\item GeneID
\item Localisation
\item MGI
\item HumanEntrez
\item MouseEntrez
\item HumanName
\item MouseName
\item PMID
\item Paper
\item Year
\item SpeciesTaxID
\item BrainRegion
}
}
\description{
Get all genes annotated for specific brain region for specific specie.
Function lookups Brain Region ID and Specie Tax ID columns and returns
main information like internal Gene IDs, MGI ID, Human Entrez ID,
Human Gene Name, Mouse Entrez ID, Mouse Gene Name,
Localisation (presynaptic, postsynaptic, synaptosomal),
PaperPMID and BrainRegion.
}
\examples{
gns <- getAllGenes4BrainRegion(brainRegion = "Striatum", taxID = 10090)
head(gns)
}
\seealso{
Other {BrainRegion functions}: 
\code{\link{getBrainRegions}()},
\code{\link{getGenes4BrainRegion}()},
\code{\link{getPPIbyIDs4BrainRegion}()}

Other {BrainRegion Gene functions}: 
\code{\link{getGenes4BrainRegion}()}
}
\concept{{BrainRegion Gene functions}}
\concept{{BrainRegion functions}}
