% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneInfo.R
\name{findGeneByPapers}
\alias{findGeneByPapers}
\title{Get gene table of frequently found genes}
\usage{
findGeneByPapers(pmids, cnt = 1)
}
\arguments{
\item{pmids}{vector of PMIDs to search for genes}

\item{cnt}{minimal number of papers that mentioned gene}
}
\value{
\code{data.frame} with 9 columns: 8 specified in
        \code{\link{getGenesByID}} and \code{Npmid} column for the paper
        count.
}
\description{
Get gene table and paper count for genes mentioned \code{cnt}
or more times in different papers.
}
\examples{
res<- getAllGenes4Compartment(compartmentID = 1)
gnt<-getGeneInfoByIDs(res$GeneID)
pmids<-names(sort(table(gnt$PaperPMID))[1:5])
cntT <- findGeneByPapers(pmids,cnt=3)
head(cntT)
}
\seealso{
getGenesByID

Other {Gene functions}: 
\code{\link{findGeneByCompartmentPaperCnt}()},
\code{\link{findGeneByPaperCnt}()},
\code{\link{findGenesByEntrez}()},
\code{\link{findGenesByName}()},
\code{\link{getAllGenes4Compartment}()},
\code{\link{getGenes4Compartment}()},
\code{\link{getGenesByID}()}
}
\concept{{Gene functions}}
