#' T2T.excluderanges
#'
#' Defined by the Boyle-Lab/Blacklist software, High Signal and Low Mappability 
#' regions
#'
#' @name T2T.excluderanges
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg38.Kundaje.GRCh38_unified_Excludable
#'
#' Defined as a combination of hg38.Lareau.hg38_peaks,
#' hg38.Boyle.hg38-Excludable.v2, and hg38.Wimberley.peakPass60Perc_sorted, 
#' followed by manual curation. Supersedes hg38.Kundaje.GRCh38.Excludable.
#'
#' @name hg38.Kundaje.GRCh38_unified_Excludable
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg38.Bernstein.Mint_Excludable_GRCh38
#'
#' Defined from Mint-ChIP (low input, multiplexed ChIP-seq) data
#'
#' @name hg38.Bernstein.Mint_Excludable_GRCh38
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg38.Boyle.hg38-Excludable.v2
#'
#' Defined by the Boyle-Lab/Blacklist software, High Signal and Low Mappability 
#' regions
#'
#' @name hg38.Boyle.hg38-Excludable.v2
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg38.Kundaje.GRCh38.Excludable
#'
#' Defined by Anshul Kundaje as a part of ENCODE and modENCODE consortia
#'
#' @name hg38.Kundaje.GRCh38.Excludable
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg38.Lareau.hg38.full.Excludable
#'
#' ENCODE excludable regions combined with regions of high homology to mtDNA 
#' (NUMT regions)
#'
#' @name hg38.Lareau.hg38.full.Excludable
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg38.Reddy.wgEncodeDacMapabilityConsensusExcludable.hg38
#'
#' Defined by the ENCODE consortium, includes satellite repeats (CATTC, GAATG, 
#' GAGTG, ACRO1), RepeatMasker repeats (ALR/Alpha, BSR/Beta), centromeric 
#' repeats, chrM, High/Low mappability islands. Has extra chromosomes, use 
#' keepStandardChromosomes() filtering
#'
#' @name hg38.Reddy.wgEncodeDacMapabilityConsensusExcludable.hg38
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg38.Wimberley.peakPass60Perc_sorted
#'
#' Defined by the ewimberley/peakPass software
#'
#' @name hg38.Wimberley.peakPass60Perc_sorted
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg38.Wold.hg38mitoExcludable
#'
#' Definition method unknown
#'
#' @name hg38.Wold.hg38mitoExcludable
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg38.Yeo.eCLIP_Excludableregions.hg38liftover.bed.fixed
#'
#' Defined from eCLIP data
#'
#' @name hg38.Yeo.eCLIP_Excludableregions.hg38liftover.bed.fixed
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg19.Boyle.hg19-Excludable.v2
#'
#' Defined by the Boyle-Lab/Blacklist software, High Signal and Low Mappability 
#' regions
#'
#' @name hg19.Boyle.hg19-Excludable.v2
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg19.Bernstein.Mint_Excludable_hg19
#'
#' Defined from Mint-ChIP (low input, multiplexed ChIP-seq) data
#'
#' @name hg19.Bernstein.Mint_Excludable_hg19
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg19.Birney.wgEncodeDacMapabilityConsensusExcludable
#'
#' Defined by the ENCODE consortium, includes satellite repeats (CATTC, GAATG, 
#' GAGTG, ACRO1), RepeatMasker repeats (ALR/Alpha, BSR/Beta), centromeric r
#' epeats, chrM, High/Low mappability islands
#'
#' @name hg19.Birney.wgEncodeDacMapabilityConsensusExcludable
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg19.Crawford.wgEncodeDukeMapabilityRegionsExcludable
#'
#' Defined by the ENCODE consortium, includes satellite repeats (CATTC, GAATG, 
#' GAGTG, ACRO1), RepeatMasker repeats (ALR/Alpha, BSR/Beta), human satellite 
#' repeat HSATII, chrM, ribosomal subunit consensus sequences LSU-rRNA_Hsa, 
#' SSU-rRNA_Hsa. Has extra chromosomes, use keepStandardChromosomes() filtering
#'
#' @name hg19.Crawford.wgEncodeDukeMapabilityRegionsExcludable
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg19.Lareau.hg19.full.Excludable
#'
#' ENCODE excludable regions combined with regions of high homology to mtDNA 
#' (NUMT regions)
#'
#' @name hg19.Lareau.hg19.full.Excludable
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg19.Wold.hg19mitoExcludable
#'
#' Definition method unknown
#'
#' @name hg19.Wold.hg19mitoExcludable
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg19.Yeo.eCLIP_Excludableregions.hg19
#'
#' Defined from eCLIP data, includes skyscraper, rRNA pseudogene, unreliably 
#' mapped satellite repeat, and low complexity skyscraper peak regions
#'
#' @name hg19.Yeo.eCLIP_Excludableregions.hg19
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm39.excluderanges
#'
#' Defined by the Boyle-Lab/Blacklist software, High Signal and Low Mappability 
#' regions
#'
#' @name mm39.excluderanges
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm10.Boyle.mm10-Excludable.v2
#'
#' Defined by the Boyle-Lab/Blacklist software, High Signal and Low Mappability 
#' regions
#'
#' @name mm10.Boyle.mm10-Excludable.v2
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm10.Hardison.Excludable.full
#'
#' Definition method unknown
#'
#' @name mm10.Hardison.Excludable.full
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm10.Hardison.psuExcludable.mm10
#'
#' Definition method unknown
#'
#' @name mm10.Hardison.psuExcludable.mm10
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm10.Kundaje.anshul.Excludable.mm10
#'
#' Defined by Anshul Kundaje as a part of ENCODE and modENCODE consortia
#'
#' @name mm10.Kundaje.anshul.Excludable.mm10
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm10.Kundaje.mm10.Excludable
#'
#' Defined by Anshul Kundaje as a part of ENCODE and modENCODE consortia
#'
#' @name mm10.Kundaje.mm10.Excludable
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm10.Lareau.mm10.full.Excludable
#'
#' ENCODE excludable regions combined with regions of high homology to mtDNA 
#' (NUMT regions)
#'
#' @name mm10.Lareau.mm10.full.Excludable
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm10.Wold.mm10mitoExcludable
#'
#' Definition method unknown
#'
#' @name mm10.Wold.mm10mitoExcludable
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm9.Lareau.mm9.full.Excludable
#'
#' ENCODE excludable regions combined with regions of high homology to mtDNA 
#' (NUMT regions)
#'
#' @name mm9.Lareau.mm9.full.Excludable
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm9.Wold.mm9mitoExcludable
#'
#' Definition method unknown
#'
#' @name mm9.Wold.mm9mitoExcludable
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' ce11.Boyle.ce11-Excludable.v2
#'
#' Defined by the Boyle-Lab/Blacklist software, High Signal and Low Mappability regions
#'
#' @name ce11.Boyle.ce11-Excludable.v2
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' ce10.Boyle.ce10-Excludable.v2
#'
#' Defined by the Boyle-Lab/Blacklist software, High Signal and Low Mappability regions
#'
#' @name ce10.Boyle.ce10-Excludable.v2
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' ce10.Kundaje.ce10-Excludable
#'
#' Defined by Anshul Kundaje, superseded by ce10.Boyle.ce10-Excludable.v2
#'
#' @name ce10.Kundaje.ce10-Excludable
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' danRer10.Domingues.Excludableed
#'
#' Defined manually using total RNA-seq.
#'
#' @name danRer10.Domingues.Excludableed
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' danRer10.Yang.Supplemental_Table_19.ChIP-seq_black_list_in_the_zebrafish_genome
#'
#' Defined via MACS2 peak calling using ChIP-seq (PMID: 33239788)
#'
#' @name danRer10.Yang.Supplemental_Table_19.ChIP-seq_black_list_in_the_zebrafish_genome
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' dm6.Boyle.dm6-Excludable.v2
#'
#' Defined by the Boyle-Lab/Blacklist software, High Signal and Low Mappability 
#' regions
#'
#' @name dm6.Boyle.dm6-Excludable.v2
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' dm3.Boyle.dm3-Excludable.v2
#'
#' Defined by the Boyle-Lab/Blacklist software, High Signal and Low Mappability regions
#'
#' @name dm3.Boyle.dm3-Excludable.v2
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' dm3.Kundaje.dm3-Excludable
#'
#' Defined by Anshul Kundaje. Contains heterochromatin chromosomes chr2LHet. Superseded by dm3.Boyle.dm3-Excludable.v2
#'
#' @name dm3.Kundaje.dm3-Excludable
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' TAIR10.Wimberley.predicted_excluded_list_sorted_0.6
#'
#' Defined by the ewimberley/peakPass software
#'
#' @name TAIR10.Wimberley.predicted_excluded_list_sorted_0.6
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' TAIR10.Klasfeld.arabidopsis_Excludable_20inputs
#'
#' Defined by the Boyle-Lab/Blacklist software, High Signal and Low Mappability 
#' regions (DOI: 10.1101/2022.02.27.482177)
#'
#' @name TAIR10.Klasfeld.arabidopsis_Excludable_20inputs
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' TAIR10.Klasfeld.arabidopsis_greenscreen_20inputs
#'
#' Defined by the green screen pipeline (DOI: 10.1101/2022.02.27.482177)
#'
#' @name TAIR10.Klasfeld.arabidopsis_greenscreen_20inputs
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' T2T.Lareau.chm13v2.0_peaks
#'
#' Regions of high homology to mtDNA (NUMT regions) defined by caleblareau/mitoblacklist
#'
#' @name T2T.Lareau.chm13v2.0_peaks
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg38.Lareau.hg38_peaks
#'
#' Regions of high homology to mtDNA (NUMT regions) defined by caleblareau/mitoblacklist
#'
#' @name hg38.Lareau.hg38_peaks
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg19.Lareau.hg19_peaks
#'
#' Regions of high homology to mtDNA (NUMT regions) defined by caleblareau/mitoblacklist
#'
#' @name hg19.Lareau.hg19_peaks
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm10.Lareau.mm10_peaks
#'
#' Regions of high homology to mtDNA (NUMT regions) defined by caleblareau/mitoblacklist
#'
#' @name mm10.Lareau.mm10_peaks
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm9.Lareau.mm9_peaks
#'
#' Regions of high homology to mtDNA (NUMT regions) defined by caleblareau/mitoblacklist
#'
#' @name mm9.Lareau.mm9_peaks
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg19.UCSC.numtS
#'
#' Human NumtS mitochondrial sequence
#'
#' @name hg19.UCSC.numtS
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm9.UCSC.numtS
#'
#' Mouse NumtS mitochondrial sequence
#'
#' @name mm9.UCSC.numtS
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' T2T.CHM13.chm13.draft_v2.0.cen_mask
#'
#' Centromeric satellite masking bed file (v2.0)
#'
#' @name T2T.CHM13.chm13.draft_v2.0.cen_mask
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' T2T.CHM13.chm13.draft_v1.1.telomere
#'
#' Telomere identified by the VGP pipeline (v1.1)
#'
#' @name T2T.CHM13.chm13.draft_v1.1.telomere
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' T2T.UCSC.censat
#'
#' T2T peri/centromeric satellite annotation (v2.0, 20220329, CHM13 v2.0)
#'
#' @name T2T.UCSC.censat
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' T2T.UCSC.gap
#'
#' Locations of assembly gaps, as determine by strings of 'N' characters (v1.0)
#'
#' @name T2T.UCSC.gap
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' T2T.UCSC.hgUnique.hg38
#'
#' Regions unique to the T2T-CHM13 v2.0 assembly compared to the GRCh38/hg38 
#' and GRCh37/hg19 reference assemblies
#'
#' @name T2T.UCSC.hgUnique.hg38
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg38.UCSC.centromere
#'
#' Gaps from centromeres
#'
#' @name hg38.UCSC.centromere
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg38.UCSC.telomere
#'
#' Gaps from telomeres
#'
#' @name hg38.UCSC.telomere
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg38.UCSC.short_arm
#'
#' Gaps on the short arm of the chromosome
#'
#' @name hg38.UCSC.short_arm
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg38.UCSC.heterochromatin
#'
#' Gaps from large blocks of heterochromatin
#'
#' @name hg38.UCSC.heterochromatin
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg38.UCSC.contig
#'
#' Gaps between contigs in scaffolds
#'
#' @name hg38.UCSC.contig
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg38.UCSC.scaffold
#'
#' Gaps between scaffolds in chromosome assemblies. Has extra chromosomes, 
#' use keepStandardChromosomes() filtering
#'
#' @name hg38.UCSC.scaffold
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg19.UCSC.centromere
#'
#' Gaps from centromeres
#'
#' @name hg19.UCSC.centromere
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg19.UCSC.telomere
#'
#' Gaps from telomeres
#'
#' @name hg19.UCSC.telomere
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg19.UCSC.short_arm
#'
#' Gaps on the short arm of the chromosome
#'
#' @name hg19.UCSC.short_arm
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg19.UCSC.heterochromatin
#'
#' Gaps from large blocks of heterochromatin
#'
#' @name hg19.UCSC.heterochromatin
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg19.UCSC.clone
#'
#' Gaps between clones in the same map contig. Has extra chromosomes, 
#' use keepStandardChromosomes() filtering
#'
#' @name hg19.UCSC.clone
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg19.UCSC.contig
#'
#' Gaps between contigs in scaffolds
#'
#' @name hg19.UCSC.contig
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' hg19.UCSC.scaffold
#'
#' Gaps between scaffolds in chromosome assemblies. Only non-autosomal chromosomes
#'
#' @name hg19.UCSC.scaffold
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm39.UCSC.centromere
#'
#' Gaps from centromeres
#'
#' @name mm39.UCSC.centromere
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm39.UCSC.telomere
#'
#' Gaps from telomeres
#'
#' @name mm39.UCSC.telomere
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm39.UCSC.short_arm
#'
#' Gaps on the short arm of the chromosome
#'
#' @name mm39.UCSC.short_arm
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm39.UCSC.contig
#'
#' Gaps between contigs in scaffolds
#'
#' @name mm39.UCSC.contig
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm39.UCSC.scaffold
#'
#' Gaps between scaffolds in chromosome assemblies
#'
#' @name mm39.UCSC.scaffold
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm10.UCSC.centromere
#'
#' Gaps from centromeres
#'
#' @name mm10.UCSC.centromere
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm10.UCSC.telomere
#'
#' Gaps from telomeres
#'
#' @name mm10.UCSC.telomere
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm10.UCSC.short_arm
#'
#' Gaps on the short arm of the chromosome
#'
#' @name mm10.UCSC.short_arm
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm10.UCSC.clone
#'
#' Gaps between clones in the same map contig. Has extra chromosomes, 
#' use keepStandardChromosomes() filtering
#'
#' @name mm10.UCSC.clone
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm10.UCSC.contig
#'
#' Gaps between contigs in scaffolds
#'
#' @name mm10.UCSC.contig
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm10.UCSC.scaffold
#'
#' Gaps between scaffolds in chromosome assemblies
#'
#' @name mm10.UCSC.scaffold
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm10.UCSC.other
#'
#' Sequence of Ns in the assembly that were not marked as gaps in the AGP 
#' (A Golden Path) assembly definition file. Has extra chromosomes, 
#' use keepStandardChromosomes() filtering
#'
#' @name mm10.UCSC.other
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm10.UCSC.fragment
#'
#' A single gap of 31 bases in chrX_GL456233_random
#'
#' @name mm10.UCSC.fragment
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm9.UCSC.centromere
#'
#' Gaps from centromeres
#'
#' @name mm9.UCSC.centromere
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm9.UCSC.fragment
#'
#' Gaps between the contigs of a draft clone. (In this context, a contig is 
#' a set of overlapping sequence reads). Has extra chromosomes, 
#' use keepStandardChromosomes() filtering
#'
#' @name mm9.UCSC.fragment
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' mm9.UCSC.contig
#'
#' Gaps between contigs in scaffolds. Has extra chromosomes, use keepStandardChromosomes() filtering
#'
#' @name mm9.UCSC.contig
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' danRer10.UCSC.contig
#'
#' Gaps between contigs in scaffolds
#'
#' @name danRer10.UCSC.contig
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' danRer10.UCSC.scaffold
#'
#' Gaps between scaffolds in chromosome assemblies
#'
#' @name danRer10.UCSC.scaffold
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' dm6.UCSC.other
#'
#' Sequence of Ns in the assembly that were not marked as gaps in the AGP (A Golden Path) assembly definition file
#'
#' @name dm6.UCSC.other
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' dm3.UCSC.contig
#'
#' dm3.UCSC.contig
#'
#' @name dm3.UCSC.contig
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' dm3.UCSC.scaffold
#'
#' Gaps between scaffolds in chromosome assemblies
#'
#' @name dm3.UCSC.scaffold
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL

#' TAIR10.UCSC.araTha1.gap
#'
#' Gaps in the May 2011 Arabidopsis thaliana genome assembly
#'
#' @name TAIR10.UCSC.araTha1.gap
#' @docType data
#' @author Mikhail Dozmorov \email{mikhail.dozmorov@gmail.com}
NULL
