% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{TENET_consensus_open_chromatin_regions}
\alias{TENET_consensus_open_chromatin_regions}
\title{TENET consensus open chromatin regions}
\source{
{
\url{https://hgdownload.cse.ucsc.edu/goldenPath/hg19/encodeDCC/wgEncodeAwgDnaseMasterSites/}
\cr
\url{https://genome.ucsc.edu/cgi-bin/hgTrackUi?db=hg19&g=wgEncodeAwgDnaseMasterSites}
\cr
\url{https://gdc.cancer.gov/about-data/publications/ATACseq-AWG}
}
}
\usage{
TENET_consensus_open_chromatin_regions(metadata = FALSE)
}
\arguments{
\item{metadata}{If TRUE, retrieve the AnnotationHub metadata instead of the
object itself. Defaults to FALSE.}
}
\value{
A GRanges object with 2,525,827 ranges and no metadata.
}
\description{
A composite GRanges object containing regions of open chromatin
from a variety of sources, primarily for use in the TENET Bioconductor
package. This dataset is composed of DNase I hypersensitive regions from the
master list compiled from 125 cell types by ENCODE, lifted over to the hg38
genome, along with TCGA ATAC-seq peaks from 410 cancer samples of 23 cancer
types. For additional information on component datasets, see the manifest
file hosted at
\url{https://github.com/rhielab/TENET.AnnotationHub/blob/devel/data-raw/TENET_consensus_datasets_manifest.tsv}.
\strong{Citations:} ENCODE Project Consortium. An
integrated encyclopedia of DNA elements in the human genome. Nature. 2012 Sep
6;489(7414):57-74. doi: 10.1038/nature11247. PMID: 22955616; PMCID:
PMC3439153. Thurman RE, Rynes E, Humbert R, et al. The accessible chromatin
landscape of the human genome. Nature. 2012 Sep 6;489(7414):75-82. doi:
10.1038/nature11232. PMID: 22955617; PMCID: PMC3721348. Corces MR, Granja JM,
Shams S, et al. The chromatin accessibility landscape of primary human
cancers. Science. 2018 Oct 26;362(6413):eaav1898. doi:
10.1126/science.aav1898. PMID: 30361341; PMCID: PMC6408149.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
TENET_consensus_open_chromatin_regions()
\dontshow{\}) # examplesIf}
}
