% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CENTREannotDb.R
\docType{class}
\name{CENTREannotDb}
\alias{CENTREannotDb}
\alias{CENTREannotDb-class}
\alias{tables}
\title{Class object for the CENTRE annotation data}
\usage{
CENTREannotDb(x)

tables(x)
}
\arguments{
\item{x}{sqlite file path}
}
\value{
class CENTREannotDb
}
\description{
The CENTRE annotation data is accessed through objects of \code{CENTREannotDb} class.
That either provides access to the ENCODE screen V3 annotation
for Human https://screen.encodeproject.org or gives access to
GENCODE basic gene annotation version 40.
}
\details{
Using \code{tables(x)} on a \code{CENTREannotDb} object returns the tables and columns
for each table in the database.
}
\examples{
##load the screen V3 annotation
ah <- AnnotationHub::AnnotationHub()
screen <- ah[["AH116731"]]
tables(screen) #get all tables and columns in the data base
}
\references{
Based on CompoundDb::CompDb.
}
