% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{getCoverage}
\alias{getCoverage}
\title{Calculate regions coverage}
\usage{
getCoverage(mat, gr)
}
\arguments{
\item{mat}{dgCMatrix interaction matrix such as produced by
\code{\link{getInteractionMatrix}}.}

\item{gr}{factor specifying features groups. Must have length equal
to number of columns in \code{mat}.}
}
\value{
Numeric vector.
}
\description{
\code{getCoverage} calculates coverage of regions (rows in interaction
matrix) by features (columns). It is possible to specify features grouping
variable \code{gr} then coverage tells how many distinct groups the region
overlap with.
}
\examples{
data("remap_mini")
y <- colnames(remap_mini)

# simple coverage
gr <- seq_along(y) \%>\% as.factor()
getCoverage(remap_mini, gr)

# per cell type coverage
gr <- sub(".*\\\\.", "", y) \%>\% as.factor()
getCoverage(remap_mini, gr)

}
