% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{filterSignatures}
\alias{filterSignatures}
\title{Filter signatures by coverage}
\usage{
filterSignatures(
  mae,
  min = 0.05,
  max = 0.95,
  ref_experiment = "Y",
  omit_experiments = c("Y", "U")
)
}
\arguments{
\item{mae}{MultiAssayExperiment object.}

\item{min}{length one numeric between 0 and 1 defining minimum promoter
coverage for the signature to pass filtering.}

\item{max}{length one numeric between 0 and 1 defining maximum promoter
coverage for the signature to pass filtering.}

\item{ref_experiment}{string giving name of experiment to use for inferring
total number of promoters.}

\item{omit_experiments}{character giving names of experiments to exclude from
filtering.}
}
\value{
MultiAssayExperiment object with selected experiments filtered.
}
\description{
Filter signatures overlapping low or high number of promoters. Useful to get
rid of signatures that have very low variance.
}
\examples{
data("rinderpest_mini", "remap_mini")
base_lvl <- "00hr"
design <- matrix(
  data = c(1, 0, 0,
           1, 0, 0,
           1, 0, 0,
           0, 1, 0,
           0, 1, 0,
           0, 1, 0,
           0, 0, 1,
           0, 0, 1,
           0, 0, 1),
  ncol = 3,
  nrow = 9,
  byrow = TRUE,
  dimnames = list(colnames(rinderpest_mini), c("00hr", "12hr", "24hr")))
mae <- prepareCountsForRegression(
  counts = rinderpest_mini,
  design = design,
  base_lvl = base_lvl)
mae <- addSignatures(mae, remap = remap_mini)
mae <- filterSignatures(mae)

}
