% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-utils.R
\name{rla}
\alias{rla}
\alias{rowRla}
\title{Calculate relative log abundances}
\usage{
rla(x, group, log.transform = TRUE)

rowRla(x, group, log.transform = TRUE)
}
\arguments{
\item{x}{\code{numeric} (for \code{rla}) or \code{matrix} (for \code{rowRla}) with the
abundances (in natural scale) on which the RLA should be calculated.}

\item{group}{\code{factor}, \code{numeric} or \code{character} with the same length
than \code{x} that groups values in \code{x}. If omitted all values are considered
to be from the same group.}

\item{log.transform}{\code{logical(1)} whether \code{x} should be log2 transformed.
Set to \code{log.transform = FALSE} if \code{x} is already in log scale.}
}
\value{
\code{numeric} of the same length than \code{x} (for \code{rla}) or \code{matrix} with
the same dimensions than \code{x} (for \code{rowRla}).
}
\description{
\code{rla} calculates the relative log abundances (RLA, see reference) on a
\code{numeric} vector.
}
\details{
The RLA is defines as the (log) abundance of an analyte relative
to the median across all abundances of the same group.
}
\examples{

x <- c(3, 4, 5, 1, 2, 3, 7, 8, 9)

grp <- c(1, 1, 1, 2, 2, 2, 3, 3, 3)

rla(x, grp)
}
\references{
De Livera AM, Dias DA, De Souza D, Rupasinghe T, Pyke J, Tull D, Roessner U,
McConville M, Speed TP. Normalizing and integrating metabolomics data.
\emph{Anal Chem} 2012 Dec 18;84(24):10768-76.
doi: \href{https://doi.org/10.1021/ac302748b}{10.1021/ac302748b}
}
\author{
Johannes Rainer
}
